/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.relation.NotEmptyIfIikIsKsn;

@NotEmptyIfIikIsKsn(field="productCode", iikField="iik", message="{publicOfficeV1.productCode.notNull}")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PublicOffice")
@Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f (F)")
public class PublicOfficeV1
implements Serializable {
    @NotNull(message="{publicOfficeV1.iik.notNull}")
    @Text(min=20, max=20, message="{publicOfficeV1.iik.size}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u0441\u0447\u0435\u0442 (F 30)")
    protected @NotNull(message="{publicOfficeV1.iik.notNull}") String iik;
    @ExactDigitsCount(count=6, message="{publicOfficeV1.productCode.digits}")
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (F 31)")
    protected String productCode;
    @NotNull(message="{publicOfficeV1.payPurpose.notNull}")
    @Text(min=1, max=240, message="{publicOfficeV1.payPurpose.size}")
    @Pattern(regexp=".[^:\\n\\r\\t]*", message="{publicOfficeV1.payPurpose.format}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (F 32)")
    protected @NotNull(message="{publicOfficeV1.payPurpose.notNull}") @Pattern(regexp=".[^:\\n\\r\\t]*", message="{publicOfficeV1.payPurpose.format}") String payPurpose;
    @NotNull(message="{publicOfficeV1.bik.notNull}")
    @Pattern(regexp="KKMFKZ2A", message="{publicOfficeV1.bik.notNull}")
    @XmlElement(defaultValue="KKMFKZ2A", required=true)
    @Documentation(value="\u0411\u0418\u041a. \u041d\u0435\u0438\u0437\u043c\u0435\u043d\u044f\u0435\u043c\u043e\u0435 \u043f\u043e\u043b\u0435 (F 33)")
    protected @NotNull(message="{publicOfficeV1.bik.notNull}") @Pattern(regexp="KKMFKZ2A", message="{publicOfficeV1.bik.notNull}") String bik = "KKMFKZ2A";

    public String getBik() {
        return this.bik;
    }

    public String getIik() {
        return this.iik;
    }

    public void setIik(String value) {
        this.iik = value;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String value) {
        this.productCode = value;
    }

    public String getPayPurpose() {
        return this.payPurpose;
    }

    public void setPayPurpose(String value) {
        this.payPurpose = value;
    }
}

