/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.VersionedDocument;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.ConsigneeV2;
import ru.uss.esf.model.invoice.version.v2.ConsignorV2;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.model.invoice.version.v2.DeliveryTermV2;
import ru.uss.esf.model.invoice.version.v2.PaperReasonTypeV2;
import ru.uss.esf.model.invoice.version.v2.ParticipantV2;
import ru.uss.esf.model.invoice.version.v2.ProductSetV2;
import ru.uss.esf.model.invoice.version.v2.ProductShareV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.model.invoice.version.v2.PublicOfficeV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.common.relation.AllNotEmptyOrEmpty;
import ru.uss.esf.validation.common.relation.Lists;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;
import ru.uss.esf.validation.invoice.version.v2.ConsigneeCountryCodeV2;
import ru.uss.esf.validation.invoice.version.v2.CurrencyCodeV2;
import ru.uss.esf.validation.invoice.version.v2.CurrencyRateCheckNullV2;
import ru.uss.esf.validation.invoice.version.v2.CustomerCountryCodeV2;
import ru.uss.esf.validation.invoice.version.v2.CustomersParticipantsV2;
import ru.uss.esf.validation.invoice.version.v2.DeliveryDocNumDateV2;
import ru.uss.esf.validation.invoice.version.v2.DeliveryTermContractV2;
import ru.uss.esf.validation.invoice.version.v2.IndividualTinCheckV2;
import ru.uss.esf.validation.invoice.version.v2.NdsRateV2;
import ru.uss.esf.validation.invoice.version.v2.PaperDateV2;
import ru.uss.esf.validation.invoice.version.v2.ParticipantsV2;
import ru.uss.esf.validation.invoice.version.v2.ProductDigitsFormatV2;
import ru.uss.esf.validation.invoice.version.v2.ProductDistributionV2;
import ru.uss.esf.validation.invoice.version.v2.ProductNdsRateTypeV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedDateV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedNumV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedRegistrationNumberV2;
import ru.uss.esf.validation.invoice.version.v2.ReorganizedTinCheckV2;
import ru.uss.esf.validation.invoice.version.v2.SellerStatusV2;
import ru.uss.esf.validation.invoice.version.v2.SellersParticipantsV2;
import ru.uss.esf.validation.invoice.version.v2.TurnoverDateV2;

@Lists.List(value={@Lists(lists={"sellers", "sellerParticipants"}, field="tin", errorNodes={"sellers"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV2.sellersAndParticipants.notEquals}"), @Lists(lists={"customers", "customerParticipants"}, field="tin", errorNodes={"customers"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV2.customersAndParticipants.notEquals}"), @Lists(lists={"productIdxList", "sellerParticipantProductList"}, errorNodes={"productSet"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV2.productsAndSellerParticipantProducts.notEquals}"), @Lists(lists={"productIdxList", "customerParticipantProductList"}, errorNodes={"productSet"}, constraint=Lists.Constraint.EQUALS_SETS, message="{invoiceV2.productsAndCustomerParticipantProducts.notEquals}"), @Lists(lists={"sellers", "customers"}, field="tin", errorNodes={"sellers", "customers"}, constraint=Lists.Constraint.DISJOINT_SETS, message="{invoiceV2.sellersAndCustomers.disjoint}")})
@AllNotEmptyOrEmpty.List(value={@AllNotEmptyOrEmpty(fields={"datePaper", "reasonPaper"}, errorNodes={"datePaper"}, message="{invoiceV2.paper.notConsistent}"), @AllNotEmptyOrEmpty(fields={"sellerParticipants", "sellerParticipantsIfExists"}, errorNodes={"sellerParticipants"}, message="{invoiceV2.sellerParticipants.notConsistent}"), @AllNotEmptyOrEmpty(fields={"customerParticipants", "customerParticipantsIfExists"}, errorNodes={"customerParticipants"}, message="{invoiceV2.customerParticipants.notConsistent}"), @AllNotEmptyOrEmpty(fields={"relatedInvoice", "relatedStatusesIfExists"}, errorNodes={"relatedInvoice"}, message="{invoiceV2.relatedInvoice.notConsistent}"), @AllNotEmptyOrEmpty(fields={"sellerAgentDocNum", "sellerAgentDocDate"}, message="{invoiceV2.sellerAgentDoc.notConsistent}"), @AllNotEmptyOrEmpty(fields={"customerAgentDocNum", "customerAgentDocDate"}, message="{invoiceV2.customerAgentDoc.notConsistent}")})
@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="reasonPaper", targetField="datePaper", message="{invoiceV2.reasonPaper.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.kbe", targetField="customerPublicOfficeStatus", message="{invoiceV2.sellers.kbe.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.bik", targetField="customerPublicOfficeStatus", message="{invoiceV2.sellers.bik.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.iik", targetField="customerPublicOfficeStatus", message="{invoiceV2.sellers.iik.notNull}"), @NotEmptyIfTargetFieldExists(field="sellers.bank", targetField="customerPublicOfficeStatus", message="{invoiceV2.sellers.bank.notNull}")})
@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="sellerAgentTin", targetField="firstSellerStatuses", expectedValues={"PRINCIPAL"}, message="{invoiceV2.sellerAgentTin.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="customerAgentTin", targetField="firstCustomerStatuses", expectedValues={"PRINCIPAL"}, message="{invoiceV2.customerAgentTin.notNull}")})
@DeliveryTermContractV2
@DeliveryDocNumDateV2
@PaperDateV2
@ParticipantsV2
@ProductDistributionV2
@TurnoverDateV2
@RelatedDateV2
@RelatedNumV2
@RelatedRegistrationNumberV2
@NdsRateV2
@ProductNdsRateTypeV2
@CurrencyCodeV2
@CustomerCountryCodeV2
@ConsigneeCountryCodeV2
@CurrencyRateCheckNullV2
@ProductDigitsFormatV2
@ReorganizedTinCheckV2
@SellerStatusV2
@IndividualTinCheckV2
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="invoice")
@XmlType(name="InvoiceV2")
@Documentation(value="\u042d\u0421\u0424")
@JsonIgnoreProperties(value={"registrationNumber", "@class"})
public class InvoiceV2
extends AbstractInvoice
implements VersionedDocument {
    @Valid
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u043c \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u0435 (2.1)")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date datePaper;
    @Valid
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u043c \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u0435 (2.1)")
    private PaperReasonTypeV2 reasonPaper;
    @Valid
    @SellersParticipantsV2
    @XmlElementWrapper(required=true)
    @XmlElement(name="seller", required=true)
    @Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a (B)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private List<SellerV2> sellers;
    @Valid
    @CustomersParticipantsV2
    @XmlElementWrapper(required=true)
    @XmlElement(name="customer", required=true)
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (C)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private List<CustomerV2> customers;
    @Valid
    @Documentation(value="\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (E)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private DeliveryTermV2 deliveryTerm;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u0440\u0443\u0437\u043e\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f (D 25)")
    @InvoiceImmutableFromSnt(fixed=false)
    private ConsignorV2 consignor;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (D 26)")
    @InvoiceImmutableFromSnt(fixed=false)
    private ConsigneeV2 consignee;
    @Valid
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f (F)")
    @ImmutableForAdditional
    private PublicOfficeV2 publicOffice;
    @Valid
    @Size(min=1, message="{invoiceV2.sellerParticipants.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="participant", required=true)
    @Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a (\u0423\u0421\u0414) (H)")
    @ImmutableForAdditional
    private @Valid @Size(min=1, message="{invoiceV2.sellerParticipants.emptyList}") List<ParticipantV2> sellerParticipants;
    @Valid
    @Size(min=1, message="{invoiceV2.customerParticipants.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="participant", required=true)
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (\u0423\u0421\u0414) (H)")
    @ImmutableForAdditional
    private @Valid @Size(min=1, message="{invoiceV2.customerParticipants.emptyList}") List<ParticipantV2> customerParticipants;
    @Text(min=1, max=255, message="{invoiceV2.addInf.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (K 43)")
    private String addInf;
    @Valid
    @NotNull(message="{invoiceV2.products.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b (\u0440\u0430\u0431\u043e\u0442\u044b, \u0443\u0441\u043b\u0443\u0433\u0438) (G)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private @Valid @NotNull(message="{invoiceV2.products.notNull}") ProductSetV2 productSet;
    @Text(min=1, max=50, message="{invoiceV2.deliveryDocNum.size}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (F 32.1)")
    @InvoiceImmutableFromSnt
    private String deliveryDocNum;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (F 32.2)")
    @InvoiceImmutableFromSnt
    private Date deliveryDocDate;
    @Text(min=1, max=50, message="{invoiceV2.deliveryDocNum.size}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (F 32.3)")
    @InvoiceImmutableFromSnt
    private String deliveryDocNum2;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0443 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433) (F 32.4)")
    @InvoiceImmutableFromSnt
    private Date deliveryDocDate2;
    @Documentation(value="\u0411\u0418\u041d (I 35)")
    @ExactDigitsCount(count=12, message="{invoiceV2.sellerAgentTin.digits}")
    @Tin(message="{invoiceV2.sellerAgentTin.format}")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String sellerAgentTin;
    @Documentation(value="\u041f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0439 (I 36)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(additional=false)
    private String sellerAgentName;
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u0430 \u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f (I 37)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(additional=false)
    private String sellerAgentAddress;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 I 38 \u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430")
    @XmlTransient
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private Long sellerProjectCode;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442-\u041d\u043e\u043c\u0435\u0440 (I 38.1)")
    @Text(min=1, max=18, message="{invoiceV2.sellerAgentDocNum.size}")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String sellerAgentDocNum;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442-\u0414\u0430\u0442\u0430 (I 38.2)")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private Date sellerAgentDocDate;
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0433\u043e (\u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430) \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f. \u0411\u0418\u041d (J 39)")
    @ExactDigitsCount(count=12, message="{invoiceV2.customerAgentTin.digits}")
    @Tin(message="{invoiceV2.customerAgentTin.format}")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String customerAgentTin;
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0433\u043e (\u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430) \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f. \u041f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0439 (J 40)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(additional=false)
    private String customerAgentName;
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0433\u043e (\u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430) \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f. \u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u0430 \u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f (J 41)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt(additional=false)
    private String customerAgentAddress;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 J 42 \u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f")
    @XmlTransient
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private Long customerProjectCode;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442-\u041d\u043e\u043c\u0435\u0440 (J 42.1)")
    @Text(min=1, max=18, message="{invoiceV2.customerAgentDocNum.size}")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private String customerAgentDocNum;
    @Documentation(value="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442-\u0414\u0430\u0442\u0430 (J 42.2)")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private Date customerAgentDocDate;
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0440\u0433\u0430\u043d\u0430 \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0434\u043e\u0445\u043e\u0434\u043e\u0432")
    @XmlTransient
    @ImmutableForAdditional
    private String kogd;

    public List<SellerV2> getSellers() {
        return this.sellers;
    }

    public void setSellers(List<SellerV2> sellers) {
        this.sellers = sellers;
    }

    public List<CustomerV2> getCustomers() {
        return this.customers;
    }

    public void setCustomers(List<CustomerV2> customers) {
        this.customers = customers;
    }

    public DeliveryTermV2 getDeliveryTerm() {
        return this.deliveryTerm;
    }

    public void setDeliveryTerm(DeliveryTermV2 deliveryTerm) {
        this.deliveryTerm = deliveryTerm;
    }

    public ConsignorV2 getConsignor() {
        return this.consignor;
    }

    public void setConsignor(ConsignorV2 consignor) {
        this.consignor = consignor;
    }

    public ConsigneeV2 getConsignee() {
        return this.consignee;
    }

    public void setConsignee(ConsigneeV2 consignee) {
        this.consignee = consignee;
    }

    public PublicOfficeV2 getPublicOffice() {
        return this.publicOffice;
    }

    public void setPublicOffice(PublicOfficeV2 publicOffice) {
        this.publicOffice = publicOffice;
    }

    public List<ParticipantV2> getSellerParticipants() {
        return this.sellerParticipants;
    }

    public void setSellerParticipants(List<ParticipantV2> sellerParticipants) {
        this.sellerParticipants = sellerParticipants;
    }

    public List<ParticipantV2> getCustomerParticipants() {
        return this.customerParticipants;
    }

    public void setCustomerParticipants(List<ParticipantV2> customerParticipants) {
        this.customerParticipants = customerParticipants;
    }

    public String getAddInf() {
        return this.addInf;
    }

    public void setAddInf(String addInf) {
        this.addInf = addInf;
    }

    public CustomerTypeV2 getCustomerPublicOfficeStatus() {
        List<CustomerV2> customers = this.getCustomers();
        if (customers != null && !customers.isEmpty() && customers.get(0).getStatuses() != null && !customers.get(0).getStatuses().isEmpty() && customers.get(0).getStatuses().contains(CustomerTypeV2.PUBLIC_OFFICE)) {
            return CustomerTypeV2.PUBLIC_OFFICE;
        }
        return null;
    }

    public List<CustomerTypeV2> getFirstCustomerStatuses() {
        List<CustomerV2> customers = this.getCustomers();
        if (customers != null && !customers.isEmpty() && customers.get(0).getStatuses() != null && !customers.get(0).getStatuses().isEmpty()) {
            return customers.get(0).getStatuses();
        }
        return Collections.emptyList();
    }

    public List<SellerTypeV2> getFirstSellerStatuses() {
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null && !sellers.isEmpty() && sellers.get(0).getStatuses() != null && !sellers.get(0).getStatuses().isEmpty()) {
            return sellers.get(0).getStatuses();
        }
        return Collections.emptyList();
    }

    public InvoiceType getRelatedStatusesIfExists() {
        if (this.getInvoiceType() != null && (this.getInvoiceType() == InvoiceType.FIXED_INVOICE || this.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE)) {
            return this.getInvoiceType();
        }
        return null;
    }

    public List<Integer> getSellerParticipantProductList() {
        return this.getParticipantProductList(this.sellerParticipants);
    }

    public List<Integer> getCustomerParticipantProductList() {
        return this.getParticipantProductList(this.customerParticipants);
    }

    @AssertTrue(message="{invoice.participantTableCountExcited}")
    public @AssertTrue(message="{invoice.participantTableCountExcited}") boolean isParticipantTableCountExcited() {
        return this.getSellerParticipantProductList() == null || this.getCustomerParticipantProductList() == null || this.getSellerParticipantProductList().size() + this.getCustomerParticipantProductList().size() <= 200;
    }

    private List<Integer> getParticipantProductList(List<ParticipantV2> participants) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            for (ParticipantV2 p : participants) {
                if (p.getProductShares() == null) {
                    return null;
                }
                for (ProductShareV2 ps : p.getProductShares()) {
                    list.add(ps.getProductNumber());
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return list;
    }

    public Integer getSellerParticipantsIfExists() {
        List<SellerV2> sellers = this.getSellers();
        if (sellers == null || sellers.size() < 2) {
            return null;
        }
        return sellers.size();
    }

    public Integer getCustomerParticipantsIfExists() {
        List<CustomerV2> customers = this.getCustomers();
        if (customers == null || customers.size() < 2) {
            return null;
        }
        return customers.size();
    }

    public String getFirstCustomerTin() {
        List<CustomerV2> customers = this.getCustomers();
        if (customers != null && !customers.isEmpty() && customers.get(0) != null && customers.get(0).getTin() != null) {
            return customers.get(0).getTin();
        }
        return null;
    }

    public String getFirstSellerTin() {
        List<SellerV2> sellers = this.getSellers();
        if (CollectionUtils.isNotEmpty(sellers) && sellers.get(0) != null && sellers.get(0).getTin() != null) {
            return sellers.get(0).getTin();
        }
        return null;
    }

    @Override
    public BigDecimal getTotalPriceWithTax() {
        if (this.getProductSet() != null) {
            return this.getProductSet().getTotalPriceWithTax();
        }
        return null;
    }

    @Override
    public String getCreatorTin() {
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null && !sellers.isEmpty()) {
            if (this.getSellerAgentTin() != null) {
                return this.getSellerAgentTin();
            }
            if (sellers.get(0) != null && !StringUtils.isEmpty((CharSequence)sellers.get(0).getBranchTin())) {
                return sellers.get(0).getBranchTin();
            }
            if (sellers.get(0) != null) {
                return sellers.get(0).getTin();
            }
        }
        return null;
    }

    @Override
    public Long getCreatorProjectCode() {
        return this.sellerProjectCode;
    }

    @Override
    public List<String> getSellerTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV2 seller : sellers) {
                if (seller == null || seller.getTin() == null) continue;
                list.add(seller.getTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getSellerReorganizedTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV2 seller : sellers) {
                if (seller == null || seller.getTin() == null || seller.getReorganizedTin() == null) continue;
                list.add(seller.getReorganizedTin());
            }
        }
        return list;
    }

    @Override
    public String getSellerReorganizedTin(int index) {
        return this.getSellers().get(index).getReorganizedTin();
    }

    @Override
    public String getCustomerReorganizedTin(int index) {
        return this.getCustomers().get(index).getReorganizedTin();
    }

    @Override
    public List<String> getSellerBranchTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV2 seller : sellers) {
                if (seller == null || seller.getBranchTin() == null) continue;
                list.add(seller.getBranchTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getSellerPartyTins() {
        LinkedList<String> list = new LinkedList<String>();
        list.addAll(this.getSellerTinList());
        list.addAll(this.getSellerBranchTinList());
        if (StringUtils.isNotBlank((CharSequence)this.getSellerAgentTin())) {
            list.add(this.getSellerAgentTin());
        }
        return list;
    }

    @Override
    public List<String> getCustomerTinList() {
        List<CustomerV2> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null || customer.getTin() == null) continue;
                list.add(customer.getTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getNullableCustomerTinList() {
        List<CustomerV2> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null) continue;
                list.add(customer.getTin());
            }
        }
        list.sort(Comparator.comparing(String::hashCode));
        return list;
    }

    @Override
    public List<String> getCustomerReorganizedTinList() {
        List<CustomerV2> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null || customer.getTin() == null || customer.getReorganizedTin() == null) continue;
                list.add(customer.getReorganizedTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getNullableCustomerReorganizedTinList() {
        List<CustomerV2> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null) continue;
                list.add(customer.getReorganizedTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getCustomerBranchTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<CustomerV2> customers = this.getCustomers();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null || customer.getBranchTin() == null) continue;
                list.add(customer.getBranchTin());
            }
        }
        return list;
    }

    @Override
    public String getStringNdsRateType() {
        if (this.getProductSet() != null && this.getProductSet().getNdsRateType() != null) {
            return this.getProductSet().getNdsRateType().name();
        }
        return null;
    }

    @Override
    public Set<String> getTnvedCodes() {
        if (this.getProductSet() != null && this.getProductSet().getProducts() != null) {
            return this.getProductSet().getProducts().stream().filter(p -> !StringUtils.isEmpty((CharSequence)p.getUnitCode())).map(ProductV2::getUnitCode).collect(Collectors.toSet());
        }
        return Collections.EMPTY_SET;
    }

    public List<String> getValidCustomerTinList() {
        List<CustomerV2> customers = this.getCustomers();
        ArrayList<String> list = new ArrayList<String>();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                if (customer == null || customer.getTin() == null || (customer.getStatuses() == null || customer.getStatuses().contains(CustomerTypeV2.NONRESIDENT)) && !TinValidator.isTin(customer.getTin())) continue;
                list.add(customer.getTin());
            }
        }
        return list;
    }

    public boolean isForExport() {
        return this.getSellers() != null && this.getSellers().stream().filter(seller -> seller.getStatuses() != null && seller.getStatuses().contains(SellerTypeV2.EXPORTER)).count() > 0L;
    }

    public boolean isCustomerNonResident() {
        return this.getCustomers() != null && this.getCustomers().stream().filter(customer -> customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV2.NONRESIDENT)).count() > 0L;
    }

    public ProductSetV2 getProductSet() {
        return this.productSet;
    }

    public void setProductSet(ProductSetV2 productSet) {
        this.productSet = productSet;
    }

    public List<ProductV2> getProductList() {
        if (this.productSet != null && this.productSet.getProducts() != null) {
            return this.productSet.getProducts();
        }
        return Collections.emptyList();
    }

    public List<Integer> getProductIdxList() {
        if (this.productSet == null || this.productSet.getProducts() == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= this.productSet.getProducts().size(); ++i) {
            list.add(i);
        }
        return list;
    }

    public Date getDatePaper() {
        return this.datePaper;
    }

    public void setDatePaper(Date datePaper) {
        this.datePaper = datePaper;
    }

    public PaperReasonTypeV2 getReasonPaper() {
        return this.reasonPaper;
    }

    public void setReasonPaper(PaperReasonTypeV2 reasonPaper) {
        this.reasonPaper = reasonPaper;
    }

    @Override
    public String getDeliveryDocNum() {
        return this.deliveryDocNum;
    }

    @Override
    public boolean isSellerLessor() {
        return this.sellers != null && this.sellers.stream().anyMatch(seller -> seller.isLessor());
    }

    public void setDeliveryDocNum(String deliveryDocNum) {
        this.deliveryDocNum = deliveryDocNum;
    }

    public Date getDeliveryDocDate() {
        return this.deliveryDocDate;
    }

    public void setDeliveryDocDate(Date deliveryDocDate) {
        this.deliveryDocDate = deliveryDocDate;
    }

    public String getDeliveryDocNum2() {
        return this.deliveryDocNum2;
    }

    public void setDeliveryDocNum2(String deliveryDocNum2) {
        this.deliveryDocNum2 = deliveryDocNum2;
    }

    public Date getDeliveryDocDate2() {
        return this.deliveryDocDate2;
    }

    public void setDeliveryDocDate2(Date deliveryDocDate2) {
        this.deliveryDocDate2 = deliveryDocDate2;
    }

    public String getSellerAgentTin() {
        return this.sellerAgentTin;
    }

    public void setSellerAgentTin(String sellerAgentTin) {
        this.sellerAgentTin = sellerAgentTin;
    }

    public String getSellerAgentName() {
        return this.sellerAgentName;
    }

    public void setSellerAgentName(String sellerAgentName) {
        this.sellerAgentName = sellerAgentName;
    }

    public String getSellerAgentAddress() {
        return this.sellerAgentAddress;
    }

    public void setSellerAgentAddress(String sellerAgentAddress) {
        this.sellerAgentAddress = sellerAgentAddress;
    }

    public Long getSellerProjectCode() {
        return this.sellerProjectCode;
    }

    public void setSellerProjectCode(Long sellerProjectCode) {
        this.sellerProjectCode = sellerProjectCode;
    }

    public String getSellerAgentDocNum() {
        return this.sellerAgentDocNum;
    }

    public void setSellerAgentDocNum(String sellerAgentDocNum) {
        this.sellerAgentDocNum = sellerAgentDocNum;
    }

    public Date getSellerAgentDocDate() {
        return this.sellerAgentDocDate;
    }

    public void setSellerAgentDocDate(Date sellerAgentDocDate) {
        this.sellerAgentDocDate = sellerAgentDocDate;
    }

    public String getCustomerAgentTin() {
        return this.customerAgentTin;
    }

    public void setCustomerAgentTin(String customerAgentTin) {
        this.customerAgentTin = customerAgentTin;
    }

    public String getCustomerAgentName() {
        return this.customerAgentName;
    }

    public void setCustomerAgentName(String customerAgentName) {
        this.customerAgentName = customerAgentName;
    }

    public String getCustomerAgentAddress() {
        return this.customerAgentAddress;
    }

    public void setCustomerAgentAddress(String customerAgentAddress) {
        this.customerAgentAddress = customerAgentAddress;
    }

    public Long getCustomerProjectCode() {
        return this.customerProjectCode;
    }

    public void setCustomerProjectCode(Long customerProjectCode) {
        this.customerProjectCode = customerProjectCode;
    }

    public String getCustomerAgentDocNum() {
        return this.customerAgentDocNum;
    }

    public void setCustomerAgentDocNum(String customerAgentDocNum) {
        this.customerAgentDocNum = customerAgentDocNum;
    }

    public Date getCustomerAgentDocDate() {
        return this.customerAgentDocDate;
    }

    public void setCustomerAgentDocDate(Date customerAgentDocDate) {
        this.customerAgentDocDate = customerAgentDocDate;
    }

    public String getKogd() {
        return this.kogd;
    }

    public void setKogd(String kogd) {
        this.kogd = kogd;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public List<? extends AbstractProduct> getProducts() {
        if (this.productSet != null && this.productSet.getProducts() != null) {
            return this.productSet.getProducts();
        }
        return Collections.emptyList();
    }

    public boolean contains(List<SellerTypeV2> sellerTypes) {
        List<SellerV2> sellers = this.getSellers();
        if (sellers != null) {
            for (SellerV2 seller : sellers) {
                List<SellerTypeV2> statuses = seller.getStatuses();
                if (statuses == null) continue;
                for (SellerTypeV2 status : statuses) {
                    if (!sellerTypes.contains(status)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public DocumentParticipantType getCustomerType() {
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV2.INDIVIDUAL)) {
            return DocumentParticipantType.INDIVIDUAL;
        }
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV2.LAWYER)) {
            return DocumentParticipantType.LAWYER;
        }
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV2.BAILIFF)) {
            return DocumentParticipantType.BAILIFF;
        }
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV2.MEDIATOR)) {
            return DocumentParticipantType.MEDIATOR;
        }
        if (!CollectionUtils.isEmpty(this.customers) && this.customers.get(0).containsStatus(CustomerTypeV2.NOTARY)) {
            return DocumentParticipantType.NOTARY;
        }
        return DocumentParticipantType.BUSINESS;
    }

    @Override
    public DocumentParticipantType getSellerType() {
        if (!CollectionUtils.isEmpty(this.sellers) && this.sellers.get(0).containsStatus(SellerTypeV2.LAWYER)) {
            return DocumentParticipantType.LAWYER;
        }
        if (!CollectionUtils.isEmpty(this.sellers) && this.sellers.get(0).containsStatus(SellerTypeV2.BAILIFF)) {
            return DocumentParticipantType.BAILIFF;
        }
        if (!CollectionUtils.isEmpty(this.sellers) && this.sellers.get(0).containsStatus(SellerTypeV2.MEDIATOR)) {
            return DocumentParticipantType.MEDIATOR;
        }
        if (!CollectionUtils.isEmpty(this.sellers) && this.sellers.get(0).containsStatus(SellerTypeV2.NOTARY)) {
            return DocumentParticipantType.NOTARY;
        }
        return DocumentParticipantType.BUSINESS;
    }

    public boolean containsCustomerStatus(List<CustomerTypeV2> customerTypes) {
        List<CustomerV2> customers = this.getCustomers();
        if (customers != null) {
            for (CustomerV2 customer : customers) {
                List<CustomerTypeV2> statuses = customer.getStatuses();
                if (statuses == null) continue;
                for (CustomerTypeV2 status : statuses) {
                    if (!customerTypes.contains(status)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

