/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.invoice.version.v2.ProductShareV2;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.Lists;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.version.v2.ProductShareNumberV2;

@ProductShareNumberV2
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Participant")
@Documentation(value="\u0423\u0421\u0414 (H)")
public class ParticipantV2
implements Serializable {
    @NotNull(message="{participantV2.tin.notNull}")
    @Tin(message="{participantV2.tin.format}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 (H 34.1)")
    private @NotNull(message="{participantV2.tin.notNull}") String tin;
    @ExactDigitsCount(count=12, message="{participantV2.reorganizedTin.digits}")
    @Documentation(value="\u0411\u0418\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 (H 34.2)")
    private String reorganizedTin;
    @Valid
    @NotNull(message="{participantV2.productShares.notNull}")
    @Size(min=1, max=200, message="{participantV2.productShares.size}")
    @Lists(constraint=Lists.Constraint.NOT_EMPTY_ELEMENTS, message="{participantV2.productShares.containsEmpty}")
    @XmlElementWrapper(required=true)
    @XmlElement(name="share", required=true)
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c (\u0440\u0430\u0431\u043e\u0442\u0430\u043c, \u0443\u0441\u043b\u0443\u0433\u0430\u043c)")
    @ImmutableForAdditional
    private @Valid @NotNull(message="{participantV2.productShares.notNull}") @Size(min=1, max=200, message="{participantV2.productShares.size}") List<ProductShareV2> productShares;

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getReorganizedTin() {
        return this.reorganizedTin;
    }

    public void setReorganizedTin(String reorganizedTin) {
        this.reorganizedTin = reorganizedTin;
    }

    public List<ProductShareV2> getProductShares() {
        return this.productShares;
    }

    public void setProductShares(List<ProductShareV2> productShares) {
        this.productShares = productShares;
    }
}

