/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.esf.annotation.EgpAwpMergeIgnore;
import ru.uss.esf.model.invoice.version.v2.NdsRateTypeV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.relation.Lists;
import ru.uss.esf.validation.common.relation.TotalOf;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;
import ru.uss.esf.validation.invoice.version.v2.ProductNumberV2;

@TotalOf.List(value={@TotalOf(field="totalPriceWithoutTax", column="products.priceWithoutTax", message="{productSetV2.totalPriceWithoutTax.sumNotEquals}"), @TotalOf(field="totalExciseAmount", column="products.exciseAmount", message="{productSetV2.totalExciseAmount.sumNotEquals}", nullAsZero=true), @TotalOf(field="totalTurnoverSize", column="products.turnoverSize", message="{productSetV2.totalTurnoverSize.sumNotEquals}"), @TotalOf(field="totalNdsAmount", column="products.ndsAmount", message="{productSetV2.totalNdsAmount.sumNotEquals}"), @TotalOf(field="totalPriceWithTax", column="products.priceWithTax", message="{productSetV2.totalPriceWithTax.sumNotEquals}")})
@ProductNumberV2
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProductSet")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c, \u0440\u0430\u0431\u043e\u0442\u0430\u043c, \u0443\u0441\u043b\u0443\u0433\u0430\u043c (G)")
public class ProductSetV2
implements Serializable {
    @NotNull(message="{productSetV2.currencyCode.notNull}")
    @Text(min=3, max=3, message="{productSetV2.currencyCode.size}")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b (G 33.1)")
    @ImmutableForAdditional
    private @NotNull(message="{productSetV2.currencyCode.notNull}") String currencyCode;
    @Digits(integer=12, fraction=6, message="{productSetV2.currencyRate.digits}")
    @DecimalFormat(message="{productSetV2.currencyRate.decimalFormat}")
    @Documentation(value="\u041a\u0443\u0440\u0441 \u0432\u0430\u043b\u044e\u0442\u044b (G 33.2)")
    private @Digits(integer=12, fraction=6, message="{productSetV2.currencyRate.digits}") BigDecimal currencyRate;
    @NotNull(message="{productSetV2.totalPriceWithoutTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productSetV2.totalPriceWithoutTax.digits}")
    @DecimalFormat(message="{productSetV2.totalPriceWithoutTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0442\u043e\u0433\u043e\u0432\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0431\u0435\u0437 \u0443\u0447\u0435\u0442\u0430 \u041d\u0414\u0421 (G 8)")
    private @NotNull(message="{productSetV2.totalPriceWithoutTax.notNull}") @Digits(integer=15, fraction=2, message="{productSetV2.totalPriceWithoutTax.digits}") BigDecimal totalPriceWithoutTax;
    @NotNull(message="{productSetV2.totalExciseAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productSetV2.totalExciseAmount.digits}")
    @DecimalFormat(message="{productSetV2.totalExciseAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0442\u043e\u0433\u043e\u0432\u0430\u044f \u0410\u043a\u0446\u0438\u0437-\u0421\u0443\u043c\u043c\u0430 (G 10)")
    private @NotNull(message="{productSetV2.totalExciseAmount.notNull}") @Digits(integer=15, fraction=2, message="{productSetV2.totalExciseAmount.digits}") BigDecimal totalExciseAmount;
    @NotNull(message="{productSetV2.totalTurnoverSize.notNull}")
    @Digits(integer=15, fraction=2, message="{productSetV2.totalTurnoverSize.digits}")
    @DecimalFormat(message="{productSetV2.totalTurnoverSize.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0442\u043e\u0433\u043e\u0432\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (G 11)")
    private @NotNull(message="{productSetV2.totalTurnoverSize.notNull}") @Digits(integer=15, fraction=2, message="{productSetV2.totalTurnoverSize.digits}") BigDecimal totalTurnoverSize;
    @NotNull(message="{productSetV2.totalNdsAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productSetV2.totalNdsAmount.digits}")
    @DecimalFormat(message="{productSetV2.totalNdsAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0442\u043e\u0433\u043e\u0432\u0430\u044f \u041d\u0414\u0421-\u0421\u0443\u043c\u043c\u0430 (G 13)")
    private @NotNull(message="{productSetV2.totalNdsAmount.notNull}") @Digits(integer=15, fraction=2, message="{productSetV2.totalNdsAmount.digits}") BigDecimal totalNdsAmount;
    @NotNull(message="{productSetV2.totalPriceWithTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productSetV2.totalPriceWithTax.digits}")
    @DecimalFormat(message="{productSetV2.totalPriceWithTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0442\u043e\u0433\u043e\u0432\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u041d\u0414\u0421 (G 14)")
    private @NotNull(message="{productSetV2.totalPriceWithTax.notNull}") @Digits(integer=15, fraction=2, message="{productSetV2.totalPriceWithTax.digits}") BigDecimal totalPriceWithTax;
    @Valid
    @NotNull(message="{productSetV2.productSet.notNull}")
    @Size(min=1, max=200, message="{productSetV2.productSet.size}")
    @Lists(constraint=Lists.Constraint.NOT_EMPTY_ELEMENTS, message="{productSetV2.productSet.containsNull}")
    @XmlElementWrapper(required=true)
    @XmlElement(name="product", required=true)
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0422\u0420\u0423")
    @EgpAwpMergeIgnore
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private @Valid @NotNull(message="{productSetV2.productSet.notNull}") @Size(min=1, max=200, message="{productSetV2.productSet.size}") List<ProductV2> products;
    @Valid
    @XmlElement
    @Documentation(value="\u0422\u0438\u043f \u041d\u0414\u0421 ('\u0411\u0435\u0437 \u041d\u0414\u0421 \u2013 \u043d\u0435 \u0420\u041a')")
    @ImmutableForAdditional
    private NdsRateTypeV2 ndsRateType;

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public List<ProductV2> getProducts() {
        return this.products;
    }

    public void setProducts(List<ProductV2> product) {
        this.products = product;
    }

    public BigDecimal getTotalPriceWithoutTax() {
        return this.totalPriceWithoutTax;
    }

    public void setTotalPriceWithoutTax(BigDecimal totalPriceWithoutTax) {
        this.totalPriceWithoutTax = BigDecimalUtils.stripTrailingZeros(totalPriceWithoutTax);
    }

    public BigDecimal getTotalExciseAmount() {
        return this.totalExciseAmount;
    }

    public void setTotalExciseAmount(BigDecimal totalExciseAmount) {
        this.totalExciseAmount = BigDecimalUtils.stripTrailingZeros(totalExciseAmount);
    }

    public BigDecimal getTotalTurnoverSize() {
        return this.totalTurnoverSize;
    }

    public void setTotalTurnoverSize(BigDecimal totalTurnoverSize) {
        this.totalTurnoverSize = BigDecimalUtils.stripTrailingZeros(totalTurnoverSize);
    }

    public BigDecimal getTotalNdsAmount() {
        return this.totalNdsAmount;
    }

    public void setTotalNdsAmount(BigDecimal totalNdsAmount) {
        this.totalNdsAmount = BigDecimalUtils.stripTrailingZeros(totalNdsAmount);
    }

    public BigDecimal getTotalPriceWithTax() {
        return this.totalPriceWithTax;
    }

    public void setTotalPriceWithTax(BigDecimal totalPriceWithTax) {
        this.totalPriceWithTax = BigDecimalUtils.stripTrailingZeros(totalPriceWithTax);
    }

    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = BigDecimalUtils.stripTrailingZeros(currencyRate);
    }

    public NdsRateTypeV2 getNdsRateType() {
        return this.ndsRateType;
    }

    public void setNdsRateType(NdsRateTypeV2 ndsRateType) {
        this.ndsRateType = ndsRateType;
    }
}

