/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import java.math.BigDecimal;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.core.validation.common.IsNull;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProductShare;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProductShare")
@Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c (\u0440\u0430\u0431\u043e\u0442\u0430\u043c, \u0443\u0441\u043b\u0443\u0433\u0430\u043c)")
public class ProductShareV2
extends AbstractProductShare {
    @Min(value=1L, message="{productShareV2.number.min}")
    @Max(value=200L, message="{productShareV2.number.max}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 (\u0442\u043e\u0432\u0430\u0440\u0430, \u0443\u0441\u043b\u0443\u0433\u0438)")
    @ImmutableForAdditional
    private @Min(value=1L, message="{productShareV2.number.min}") @Max(value=200L, message="{productShareV2.number.max}") int productNumber;
    @XmlElement(required=false)
    @InvoiceImmutableFromSnt
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 (\u0442\u043e\u0432\u0430\u0440\u0430, \u0443\u0441\u043b\u0443\u0433\u0438) \u0438\u0437 \u0421\u041d\u0422 (H 1)")
    private String productNumberInSnt;
    @Digits(integer=12, fraction=6, message="{productShareV2.quantity.digits}")
    @DecimalFormat(message="{productShareV2.quantity.decimalFormat}")
    @Documentation(value="\u041a\u043e\u043b-\u0432\u043e (\u043e\u0431\u044a\u0435\u043c) (H 6)")
    private @Digits(integer=12, fraction=6, message="{productShareV2.quantity.digits}") BigDecimal quantity;
    @Digits(integer=12, fraction=6, message="{productV2.quantitativeQuantity.digits}")
    @DecimalFormat(message="{productV2.quantitativeQuantity.decimalFormat}")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0435\u0434\u0438\u043d\u0438\u0446\u0435 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (H 6/1")
    @ImmutableForAdditional
    private @Digits(integer=12, fraction=6, message="{productV2.quantitativeQuantity.digits}") BigDecimal quantitativeQuantity;
    @NotNull(message="{productShareV2.priceWithoutTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV2.priceWithoutTax.digits}")
    @DecimalFormat(message="{productShareV2.priceWithoutTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0431\u0435\u0437 \u0443\u0447\u0435\u0442\u0430 \u041d\u0414\u0421 (H 7)")
    private @NotNull(message="{productShareV2.priceWithoutTax.notNull}") @Digits(integer=15, fraction=2, message="{productShareV2.priceWithoutTax.digits}") BigDecimal priceWithoutTax;
    @Digits(integer=15, fraction=2, message="{productShareV2.exciseAmount.digits}")
    @DecimalFormat(message="{productShareV2.exciseAmount.decimalFormat}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0443\u043c\u043c\u0430 (H 10)")
    private @Digits(integer=15, fraction=2, message="{productShareV2.exciseAmount.digits}") BigDecimal exciseAmount;
    @NotNull(message="{productShareV2.turnoverSize.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV2.turnoverSize.digits}")
    @DecimalFormat(message="{productShareV2.turnoverSize.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (H 11)")
    private @NotNull(message="{productShareV2.turnoverSize.notNull}") @Digits(integer=15, fraction=2, message="{productShareV2.turnoverSize.digits}") BigDecimal turnoverSize;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0442\u0430\u0432\u043a\u0430 (G 12)")
    private Integer ndsRate;
    @NotNull(message="{productShareV2.ndsAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV2.ndsAmount.digits}")
    @DecimalFormat(message="{productShareV2.ndsAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0443\u043c\u043c\u0430 (H 13)")
    private @NotNull(message="{productShareV2.ndsAmount.notNull}") @Digits(integer=15, fraction=2, message="{productShareV2.ndsAmount.digits}") BigDecimal ndsAmount;
    @NotNull(message="{productShareV2.priceWithTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV2.priceWithTax.digits}")
    @DecimalFormat(message="{productShareV2.priceWithTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u041d\u0414\u0421 (H 15)")
    private @NotNull(message="{productShareV2.priceWithTax.notNull}") @Digits(integer=15, fraction=2, message="{productShareV2.priceWithTax.digits}") BigDecimal priceWithTax;
    @Text(min=1, max=255, message="{productShareV2.additional.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 (H 19)")
    private String additional;
    @IsNull(message="{productShareV2.additionalUnitNomenclature.mustBeNull}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (H 20)")
    @XmlElement(required=false)
    private String additionalUnitNomenclature;

    public int getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(int productNumber) {
        this.productNumber = productNumber;
    }

    public String getProductNumberInSnt() {
        return this.productNumberInSnt;
    }

    public void setProductNumberInSnt(String productNumberInSnt) {
        this.productNumberInSnt = productNumberInSnt;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getQuantitativeQuantity() {
        return this.quantitativeQuantity;
    }

    public void setQuantitativeQuantity(BigDecimal quantitativeQuantity) {
        this.quantitativeQuantity = quantitativeQuantity;
    }

    public BigDecimal getPriceWithoutTax() {
        return this.priceWithoutTax;
    }

    public void setPriceWithoutTax(BigDecimal value) {
        this.priceWithoutTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getExciseAmount() {
        return this.exciseAmount;
    }

    public void setExciseAmount(BigDecimal value) {
        this.exciseAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getTurnoverSize() {
        return this.turnoverSize;
    }

    public void setTurnoverSize(BigDecimal value) {
        this.turnoverSize = BigDecimalUtils.stripTrailingZeros(value);
    }

    public Integer getNdsRate() {
        return this.ndsRate;
    }

    public void setNdsRate(Integer ndsRate) {
        this.ndsRate = ndsRate;
    }

    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal value) {
        this.ndsAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getPriceWithTax() {
        return this.priceWithTax;
    }

    public void setPriceWithTax(BigDecimal value) {
        this.priceWithTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public String getAdditionalUnitNomenclature() {
        return this.additionalUnitNomenclature;
    }

    public void setAdditionalUnitNomenclature(String additionalUnitNomenclature) {
        this.additionalUnitNomenclature = additionalUnitNomenclature;
    }
}

