/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.IsNull;
import ru.uss.esf.annotation.EgpAwpMergePriority;
import ru.uss.esf.model.invoice.LegalEntity;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractParticipant;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.AllNotEmptyOrEmpty;
import ru.uss.esf.validation.invoice.ImmutableForAdditional;
import ru.uss.esf.validation.invoice.InvoiceImmutableFromSnt;
import ru.uss.esf.validation.invoice.version.v2.field.SellerTypesV2;

@AllNotEmptyOrEmpty.List(value={@AllNotEmptyOrEmpty(fields={"certificateSeries", "certificateNum"}, message="{sellerV2.certificate.notConsistent}"), @AllNotEmptyOrEmpty(fields={"kbe", "bik", "iik", "bank"}, message="{sellerV2.bankFields.notConsistent}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Seller")
@Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (B)")
public class SellerV2
extends AbstractParticipant
implements Serializable,
LegalEntity {
    @NotNull(message="{sellerV2.tin.notNull}")
    @Tin(message="{sellerV2.tin.format}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d (B 6)")
    @InvoiceImmutableFromSnt
    private @NotNull(message="{sellerV2.tin.notNull}") String tin;
    @Transient
    @ExactDigitsCount(count=12, message="{sellerV2.reorganizedTin.digits}")
    @Documentation(value="\u0411\u0418\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 (B 6.1)")
    private String reorganizedTin;
    @NotNull(message="{sellerV2.name.notNull}")
    @Text(min=1, max=450, message="{sellerV2.name.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (B 7)")
    private @NotNull(message="{sellerV2.name.notNull}") String name;
    @Documentation(value="\u0414\u043e\u043b\u044f \u0443\u0447\u0430\u0441\u0442\u0438\u044f (B 7.1)")
    @Digits(integer=12, fraction=6, message="{sellerV2.shareParticipation.digits}")
    @ImmutableForAdditional
    private @Digits(integer=12, fraction=6, message="{sellerV2.shareParticipation.digits}") BigDecimal shareParticipation;
    @Text(min=3, max=255, message="{sellerV2.address.size}")
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 (B 8)")
    private String address;
    @ExactDigitsCount(count=5, message="{sellerV2.certificateSeries.digits}")
    @Documentation(value="\u0421\u0435\u0440\u0438\u044f c\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u041d\u0414\u0421 (B 9.1)")
    private String certificateSeries;
    @ExactDigitsCount(count=7, message="{sellerV2.certificateNum.digits}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 c\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u041d\u0414\u0421 (B 9.2)")
    private String certificateNum;
    @XmlElement
    @Documentation(value="C\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u043d\u043e\u0435 \u043f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u044e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043b\u0438\u0446\u0430-\u043d\u0435\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442\u0430 (B 9.3)")
    private Boolean isBranchNonResident;
    @SellerTypesV2
    @XmlElementWrapper
    @XmlElement(name="status", required=true)
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (B 10)")
    @ImmutableForAdditional
    @InvoiceImmutableFromSnt
    private List<SellerTypeV2> statuses;
    @Text(min=1, max=255, message="{sellerV2.trailer.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f (B 11)")
    private String trailer;
    @EgpAwpMergePriority
    @ExactDigitsCount(count=2, message="{sellerV2.kbe.digits}")
    @Documentation(value="\u041a\u0411\u0435 (B1 12)")
    private String kbe;
    @EgpAwpMergePriority
    @Pattern(regexp="[0-9A-Z]{20}", message="{sellerV2.iik.pattern}")
    @Documentation(value="\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u0441\u0447\u0435\u0442 (B1 13)")
    private @Pattern(regexp="[0-9A-Z]{20}", message="{sellerV2.iik.pattern}") String iik;
    @EgpAwpMergePriority
    @Pattern(regexp="[0-9A-Z]{8}", message="{sellerV2.bik.pattern}")
    @Documentation(value="\u0411\u0418\u041a (B1 14)")
    private @Pattern(regexp="[0-9A-Z]{8}", message="{sellerV2.bik.pattern}") String bik;
    @EgpAwpMergePriority
    @Text(min=1, max=450, message="{sellerV2.bank.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430 (B1 15)")
    private String bank;
    @Documentation(value="\u0411\u0418\u041d \u0444\u0438\u043b\u0438\u0430\u043b\u0430, \u0432\u044b\u043f\u0438\u0441\u0430\u0432\u0448\u0435\u0433\u043e \u042d\u0421\u0424 \u0437\u0430 \u0433\u043e\u043b\u043e\u0432\u0443")
    @ExactDigitsCount(count=12, message="{sellerV2.branchTin.digits}")
    @Tin(message="{sellerV2.branchTin.format}")
    @ImmutableForAdditional
    private String branchTin;
    @IsNull(message="{sellerV2.ndscaKbe.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u0411\u0435 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 (B2 12.1)")
    private String ndscaKbe;
    @IsNull(message="{sellerV2.ndscaIik.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0418\u041a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 (B2 13.1)")
    private String ndscaIik;
    @IsNull(message="{sellerV2.ndscaBik.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u0411\u0418\u041a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 (B2 14.1)")
    private String ndscaBik;
    @IsNull(message="{sellerV2.ndscaBank.mustBeNull}")
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 (B2 15.1)")
    private String ndscaBank;
    @XmlTransient
    private Long branchTinSearch;

    public String getCertificateSeries() {
        return this.certificateSeries;
    }

    public void setCertificateSeries(String value) {
        this.certificateSeries = value;
    }

    public String getCertificateNum() {
        return this.certificateNum;
    }

    public void setCertificateNum(String value) {
        this.certificateNum = value;
    }

    public Boolean getBranchNonResident() {
        return this.isBranchNonResident;
    }

    public void setBranchNonResident(Boolean branchNonResident) {
        this.isBranchNonResident = branchNonResident;
    }

    public List<SellerTypeV2> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<SellerTypeV2> statuses) {
        this.statuses = statuses;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String trailer) {
        this.trailer = trailer;
    }

    public String getKbe() {
        return this.kbe;
    }

    public void setKbe(String kbe) {
        this.kbe = kbe;
    }

    public String getBik() {
        return this.bik;
    }

    public void setBik(String bik) {
        this.bik = bik;
    }

    public String getIik() {
        return this.iik;
    }

    public void setIik(String iik) {
        this.iik = iik;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    @Override
    public String getTin() {
        return this.tin;
    }

    @Override
    public boolean isLessor() {
        return this.statuses != null && this.statuses.contains(SellerTypeV2.LESSOR);
    }

    @Override
    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getReorganizedTin() {
        return this.reorganizedTin;
    }

    public void setReorganizedTin(String reorganizedTin) {
        this.reorganizedTin = reorganizedTin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getShareParticipation() {
        return this.shareParticipation;
    }

    public void setShareParticipation(BigDecimal shareParticipation) {
        this.shareParticipation = shareParticipation;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    public String getBranchTin() {
        return this.branchTin;
    }

    public void setBranchTin(String branchTin) {
        this.branchTin = branchTin;
    }

    public String getNdscaKbe() {
        return this.ndscaKbe;
    }

    public void setNdscaKbe(String ndscaKbe) {
        this.ndscaKbe = ndscaKbe;
    }

    public String getNdscaIik() {
        return this.ndscaIik;
    }

    public void setNdscaIik(String ndscaIik) {
        this.ndscaIik = ndscaIik;
    }

    public String getNdscaBik() {
        return this.ndscaBik;
    }

    public void setNdscaBik(String ndscaBik) {
        this.ndscaBik = ndscaBik;
    }

    public String getNdscaBank() {
        return this.ndscaBank;
    }

    public void setNdscaBank(String ndscaBank) {
        this.ndscaBank = ndscaBank;
    }

    public Long getBranchTinSearch() {
        return this.branchTinSearch;
    }

    public void setBranchTinSearch(Long branchTinSearch) {
        this.branchTinSearch = branchTinSearch;
    }

    public boolean containsStatus(SellerTypeV2 status) {
        return this.statuses != null && this.statuses.contains(status);
    }

    @Override
    public boolean isNonResident() {
        return false;
    }

    @Override
    public boolean isRetail() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }
}

