/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.isgo.invoice;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorCode;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Error")
@Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
public class IsgoError {
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private Long documentId;
    @XmlElement
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private String number;
    @XmlElement
    @Documentation(value="\u041f\u043e\u043b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private String property;
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String errorCode;
    @XmlElement
    @Documentation(value="\u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String text;

    public IsgoError() {
    }

    public IsgoError(Long documentId, String number, String property, String errorCode, String text) {
        this.documentId = documentId;
        this.number = number;
        this.property = property;
        this.errorCode = errorCode;
        this.text = text;
    }

    public IsgoError(String errorCode) {
        this.errorCode = errorCode;
    }

    public IsgoError(String errorCode, String text) {
        this.errorCode = errorCode;
        this.text = text;
    }

    public static IsgoError createFromError(Error error) {
        return new IsgoError(error.getDocumentId(), null, error.getProperty(), error == null ? null : error.getErrorCode().name(), error.getText());
    }

    public static IsgoError createByErrorCode(ErrorCode errorCode) {
        return new IsgoError(errorCode == null ? null : errorCode.name());
    }

    public static IsgoError createByErrorCode(ErrorCode errorCode, String text) {
        return new IsgoError(errorCode == null ? null : errorCode.name(), text);
    }

    public static IsgoError createByNumber(String registrationNumber, ErrorCode errorCode) {
        return new IsgoError(null, registrationNumber, null, errorCode == null ? null : errorCode.name(), null);
    }

    public static IsgoError createByNumber(String registrationNumber, String property, ErrorCode errorCode) {
        return new IsgoError(null, registrationNumber, property, errorCode == null ? null : errorCode.name(), null);
    }

    public static IsgoError createByNumber(String registrationNumber, String property, String message, ErrorCode errorCode) {
        return new IsgoError(null, registrationNumber, property, errorCode == null ? null : errorCode.name(), message);
    }

    public static IsgoError createByDocumentId(Long documentId, ErrorCode errorCode) {
        return IsgoError.createByDocumentId(documentId, null, errorCode);
    }

    public static IsgoError createByDocumentId(Long documentId, String property, ErrorCode errorCode) {
        return new IsgoError(documentId, null, property, errorCode == null ? null : errorCode.name(), null);
    }

    public Error convertToError() {
        return new Error(this.documentId, this.property, this.errorCode == null ? null : ErrorCode.valueOf(this.errorCode), this.text);
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "IsgoError{documentId=" + this.documentId + ", number='" + this.number + '\'' + ", property='" + this.property + '\'' + ", errorCode='" + this.errorCode + '\'' + ", text='" + this.text + '\'' + '}';
    }
}

