/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldExists;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;
import ru.uss.esf.validation.snt.version.v1.SntDeclarationNumberFormatV1;
import ru.uss.esf.validation.snt.version.v1.SntNdsAmountCheckV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNumberInDeclarationV2;

@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="tnvedCode", targetField="truOriginCode", expectedValues={"1", "2", "3", "4", "5"}, message="{sntBaseProductV1.tnvedCode.notNull}")})
@NotEmptyIfTargetFieldExists.List(value={@NotEmptyIfTargetFieldExists(field="ndsAmount", targetField="ndsRate", message="{sntBaseProductV1.ndsAmount.notNull}"), @NotEmptyIfTargetFieldExists(field="exciseAmount", targetField="exciseRate", message="{sntBaseProductV1.exciseAmount.notNull}"), @NotEmptyIfTargetFieldExists(field="exciseRate", targetField="exciseAmount", message="{sntBaseProductV1.exciseRate.notNull}")})
@SntProductNumberInDeclarationV2
@SntNdsAmountCheckV1
@SntDeclarationNumberFormatV1(declarationNumberField="declarationNumberForSnt", truOriginCodeField="truOriginCode")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntBaseProductV1")
public abstract class SntBaseProductV1
extends SntAbstractProduct {
    @XmlTransient
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0411\u0443\u0442\u044b\u043b\u043e\u043a")
    public static final String BOTTLE_UNIT_CODE = "868";
    @XmlTransient
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u041b\u0438\u0442\u0440")
    public static final String LITER_UNIT_CODE = "112";
    @XmlTransient
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u0428\u0442\u0443\u043a\u0430")
    public static final String PIECE_UNIT_CODE = "796";
    @XmlTransient
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u0422\u043e\u043d\u043d\u0430")
    public static final String TON_UNIT_CODE = "168";
    @IsNotNull(fieldPath="sntBaseProductV1.productNumber")
    @Pattern(regexp="[1-9][0-9]{0,2}", message="{sntBaseProductV1.productNumber.pattern}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u0421\u041d\u0422 (G1 1, G2 1, G3 1, G4 1, G5 1, G6 1, G7 1, G8 1, G9 1, G10 1)")
    protected @Pattern(regexp="[1-9][0-9]{0,2}", message="{sntBaseProductV1.productNumber.pattern}") String productNumber;
    @IsNotNull(fieldPath="sntBaseProductV1.truOriginCode")
    @Pattern(regexp="[1-5]", message="{sntBaseProductV1.truOriginCode.pattern}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430 (G1 2, G2 2, G3 2, G4 2, G5 2, G6 2, G7 2, G8 2, G9 2, G10 2)")
    protected @Pattern(regexp="[1-5]", message="{sntBaseProductV1.truOriginCode.pattern}") String truOriginCode;
    @RequiredString(required=true, minLen=10, maxLen=10, fieldPath="sntBaseProductV1.tnvedCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (\u0422\u041d \u0412\u042d\u0414 \u0415\u0410\u042d\u0421) (G1 4, G2 5, G3 5, G4 5, G5 5, G6 5, G7 4, G8 5, G9 5, G10 7)")
    protected String tnvedCode;
    @PositiveOrZero(fieldPath="sntBaseProductV1.priceWithoutTax")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=2, fieldPath="sntBaseProductV1.priceWithoutTax")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0442\u043e\u0432\u0430\u0440\u0430 \u0431\u0435\u0437 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 (G1 8, G2 8, G3 8, G4 12, G5 11, G6 9, G7 8, G8 11, G9 8, G10 11)")
    protected BigDecimal priceWithoutTax;
    @Max(value=100L, message="{sntBaseProductV1.ndsRate.max}")
    @Min(value=0L, message="{sntBaseProductV1.ndsRate.min}")
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421 (G1 10, G2 10, G3 10, G4 14, G5 13, G6 11, G7 10, G8 13, G9 10, G10 13)")
    private @Max(value=100L, message="{sntBaseProductV1.ndsRate.max}") @Min(value=0L, message="{sntBaseProductV1.ndsRate.min}") Integer ndsRate;
    @PositiveOrZero(fieldPath="sntBaseProductV1.ndsAmount")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=2, fieldPath="sntBaseProductV1.ndsAmount")
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0443\u043c\u043c\u0430 \u041d\u0414\u0421 (G1 11, G2 11, G3 11, G4 15, G5 14, G6 12, G7 11, G8 14, G9 11, G10 14)")
    private BigDecimal ndsAmount;
    @PositiveOrZero(fieldPath="sntBaseProductV1.exciseRate")
    @BigDecimalCheck(nullable=true, maxLeftLen=10, maxRightLen=2, fieldPath="sntBaseProductV1.exciseRate")
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0430\u0432\u043a\u0430 \u0430\u043a\u0446\u0438\u0437\u0430 (G1 9/1, G2 9/2, G3 9/1, G4 13/1, G5 12/2, G6 10/1, G7 9/1, G8 12/1, G9 9/1, G10 12/1)")
    private BigDecimal exciseRate;
    @PositiveOrZero(fieldPath="sntBaseProductV1.exciseAmount")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=2, fieldPath="sntBaseProductV1.exciseAmount")
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0443\u043c\u043c\u0430 \u0430\u043a\u0446\u0438\u0437\u0430 (G1 9, G2 9, G3 9, G4 13, G5 12, G6 10, G7 9, G8 12, G9 9, G10 12)")
    private BigDecimal exciseAmount;
    @PositiveOrZero(fieldPath="sntBaseProductV1.priceWithTax")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=2, fieldPath="sntBaseProductV1.priceWithTax")
    @XmlElement(required=true)
    @Documentation(value="\u041e\u0431\u0449\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c  \u0442\u043e\u0432\u0430\u0440\u0430 \u0441 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u043c\u0438 \u043d\u0430\u043b\u043e\u0433\u0430\u043c\u0438 (G1 12, G2 12, G3 12, G4 16, G5 15, G6 13, G7 12, G8 15, G9 12, G10 15)")
    private BigDecimal priceWithTax;
    @RequiredString(required=false, minLen=11, maxLen=42, fieldPath="sntBaseProductV1.declarationNumberForSnt")
    @XmlElement(required=false)
    @Documentation(value="\u2116 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043e \u0432\u044b\u043f\u0443\u0441\u043a\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0434\u043e \u043f\u043e\u0434\u0430\u0447\u0438 \u0434\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u044b, \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043e \u0432\u0432\u043e\u0437\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438 \u0443\u043f\u043b\u0430\u0442\u0435 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432, \u0421\u0422-1 \u0438\u043b\u0438 \u0421\u0422-KZ, \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0439 \u0421\u041d\u0422 (G1 14, G2 14, G3 14, G4 18, G5 16, G6 15, G7 14, G8 17, G9 14, G10 17)")
    protected String declarationNumberForSnt;
    @RequiredString(required=false, minLen=1, maxLen=11, fieldPath="sntBaseProductV1.productNumberInDeclaration")
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0438\u0437 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043e \u0432\u044b\u043f\u0443\u0441\u043a\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0434\u043e \u043f\u043e\u0434\u0430\u0447\u0438 \u0434\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u044b , \u043e \u0432\u0432\u043e\u0437\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438 \u0443\u043f\u043b\u0430\u0442\u0435 \u043a\u043e\u0441\u0432\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 \u0438\u043b\u0438 \u0414\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u044b, \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0439 \u0421\u041d\u0422 (G1 15, G2 15, G3 15, G4 19, G5 17, G6 16, G7 15, G8 18, G9 15, G10 18)")
    protected String productNumberInDeclaration;
    @RequiredString(required=false, minLen=1, maxLen=255, fieldPath="sntBaseProductV1.productId")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u0418\u0421 \u042d\u0421\u0424  (G1 13, G2 13, G3 13, G4 17, G5 15, G6 14, G7 13, G8 16, G9 13, G10 16)")
    protected String productId;
    @RequiredString(required=false, minLen=1, maxLen=255, fieldPath="sntBaseProductV1.additionalInfo")
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f (G1 17, G2 17, G3 17, G4 21, G5 19, G6 17, G7 16, G8 20, G9 16, G10 19)")
    private String additionalInfo;
    @JsonIgnore
    @XmlTransient
    private Long permissiveDocumentId;
    @JsonIgnore
    @XmlTransient
    private boolean isPermissiveDocumentRequired;
    @XmlTransient
    @Documentation(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u0432\u0430\u0440\u044b \u0441 \u043f\u0440\u0438\u0437\u043d\u0430\u043a\u043e\u043c '\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c'")
    private Boolean hasProductsWithExportControl;
    @XmlTransient
    @Documentation(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u0432\u0430\u0440\u044b \u0438\u0437 '\u041f\u0435\u0440\u0435\u0447\u043d\u044f \u0438\u0437\u044a\u044f\u0442\u0438\u044f'")
    private Boolean hasProductsWithdrawal;
    @XmlTransient
    @Documentation(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u0432\u0430\u0440\u044b \u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043a \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044e")
    private Boolean hasProductsBannedToTransfer;
    @XmlTransient
    @Documentation(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0437\u043d\u0430\u0447\u0438\u043c\u044b\u0435 \u0442\u043e\u0432\u0430\u0440\u044b")
    private Boolean hasProductsSociallySignificant;

    public abstract String getMeasureUnitCode();

    public abstract String getProductName();

    public BigDecimal getMatchingQuantity() {
        return this.getQuantity();
    }

    public String getMatchingMeasureUnitCode() {
        return this.getMeasureUnitCode();
    }

    public BigDecimal getQuantityToStore() {
        return this.getQuantity();
    }

    public abstract String getPinCode();

    @JsonIgnore
    @XmlTransient
    public String getMarkingCode() {
        return null;
    }

    @Override
    public String getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    @Override
    public String getTruOriginCode() {
        return this.truOriginCode;
    }

    public void setTruOriginCode(String truOriginCode) {
        this.truOriginCode = truOriginCode;
    }

    @Override
    public String getTnvedCode() {
        return this.tnvedCode;
    }

    public void setTnvedCode(String tnvedCode) {
        this.tnvedCode = tnvedCode;
    }

    public BigDecimal getPriceWithoutTax() {
        return this.priceWithoutTax;
    }

    public void setPriceWithoutTax(BigDecimal priceWithoutTax) {
        this.priceWithoutTax = priceWithoutTax;
    }

    @Override
    public Integer getNdsRate() {
        return this.ndsRate;
    }

    public void setNdsRate(Integer ndsRate) {
        this.ndsRate = ndsRate;
    }

    @Override
    public BigDecimal getExciseRate() {
        return this.exciseRate;
    }

    public void setExciseRate(BigDecimal exciseRate) {
        this.exciseRate = exciseRate;
    }

    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal ndsAmount) {
        this.ndsAmount = ndsAmount;
    }

    public BigDecimal getExciseAmount() {
        return this.exciseAmount;
    }

    public void setExciseAmount(BigDecimal exciseAmount) {
        this.exciseAmount = exciseAmount;
    }

    public BigDecimal getPriceWithTax() {
        return this.priceWithTax;
    }

    public void setPriceWithTax(BigDecimal priceWithTax) {
        this.priceWithTax = priceWithTax;
    }

    @Override
    public String getDeclarationNumberForSnt() {
        return this.declarationNumberForSnt;
    }

    public void setDeclarationNumberForSnt(String declarationNumberForSnt) {
        this.declarationNumberForSnt = declarationNumberForSnt;
    }

    @Override
    public String getProductNumberInDeclaration() {
        return this.productNumberInDeclaration;
    }

    public void setProductNumberInDeclaration(String productNumberInDeclaration) {
        this.productNumberInDeclaration = productNumberInDeclaration;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public String getProductPath() {
        int productSetIdx = this.getProductSetIdx();
        return SntProductTypeV1.findProductPath(productSetIdx);
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @JsonIgnore
    public Long getPermissiveDocumentId() {
        return this.permissiveDocumentId;
    }

    public void setPermissiveDocumentId(Long permissiveDocumentId) {
        this.permissiveDocumentId = permissiveDocumentId;
    }

    public boolean isPermissiveDocumentRequired() {
        return this.isPermissiveDocumentRequired;
    }

    public void setPermissiveDocumentRequired(boolean permissiveDocumentRequired) {
        this.isPermissiveDocumentRequired = permissiveDocumentRequired;
    }

    public Boolean getHasProductsWithExportControl() {
        return this.hasProductsWithExportControl;
    }

    public void setHasProductsWithExportControl(Boolean hasProductsWithExportControl) {
        this.hasProductsWithExportControl = hasProductsWithExportControl;
    }

    public Boolean getHasProductsWithdrawal() {
        return this.hasProductsWithdrawal;
    }

    public void setHasProductsWithdrawal(Boolean hasProductsWithdrawal) {
        this.hasProductsWithdrawal = hasProductsWithdrawal;
    }

    public Boolean getHasProductsBannedToTransfer() {
        return this.hasProductsBannedToTransfer;
    }

    public void setHasProductsBannedToTransfer(Boolean hasProductsBannedToTransfer) {
        this.hasProductsBannedToTransfer = hasProductsBannedToTransfer;
    }

    public Boolean getHasProductsSociallySignificant() {
        return this.hasProductsSociallySignificant;
    }

    public void setHasProductsSociallySignificant(Boolean hasProductsSociallySignificant) {
        this.hasProductsSociallySignificant = hasProductsSociallySignificant;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public int getProductSetIdx() {
        return this.getSntProductType().getProductSetIdx();
    }

    public abstract SntProductTypeV1 getSntProductType();

    public String getVstoreQuantityPath() {
        return "quantity";
    }

    public BigDecimal getSpiritPercent() {
        return null;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public String getFullProductNumber() {
        return this.getProductSetIdx() + "/" + this.getProductNumber();
    }

    public String toString() {
        return "SntBaseProductV1{productNumber='" + this.productNumber + '\'' + ", truOriginCode='" + this.truOriginCode + '\'' + ", tnvedCode='" + this.tnvedCode + '\'' + ", priceWithoutTax=" + this.priceWithoutTax + ", ndsRate=" + this.ndsRate + ", ndsAmount=" + this.ndsAmount + ", exciseRate=" + this.exciseRate + ", exciseAmount=" + this.exciseAmount + ", priceWithTax=" + this.priceWithTax + ", declarationNumberForSnt='" + this.declarationNumberForSnt + '\'' + ", productNumberInDeclaration='" + this.productNumberInDeclaration + '\'' + ", productId='" + this.productId + '\'' + ", additionalInfo='" + this.additionalInfo + '\'' + ", permissiveDocumentId=" + this.permissiveDocumentId + ", isPermissiveDocumentRequired=" + this.isPermissiveDocumentRequired + ", hasProductsWithExportControl=" + this.hasProductsWithExportControl + ", hasProductsWithdrawal=" + this.hasProductsWithdrawal + ", hasProductsBannedToTransfer=" + this.hasProductsBannedToTransfer + ", hasProductsSociallySignificant=" + this.hasProductsSociallySignificant + '}';
    }
}

