/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.IsNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.version.v1.SntBaseProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntBiofuelProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntBiofuelSet")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0431\u0438\u043e\u0442\u043e\u043f\u043b\u0438\u0432\u0443 (G7)")
public class SntBiofuelSetV1
extends SntBaseProductSetV1 {
    @XmlTransient
    public static final String OPERATION_CODE_BAIKONUR_SHIPPING_BIOFUEL = "34";
    @XmlTransient
    public static final String OPERATION_CODE_FINAL_USER = "37";
    @XmlTransient
    public static final String OPERATION_CODE_RETAIL = "31";
    @IsNull(fieldPath="sntBiofuelSetV1.operationCode", groups={SntValidationGroups.ReturnedSnt.class})
    @Pattern(regexp="30|31|34|37", message="{sntBiofuelSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})
    @RequiredString(required=false, minLen=2, maxLen=2, fieldPath="sntBiofuelSetV1.operationCode", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (G7 69)")
    private @Pattern(regexp="30|31|34|37", message="{sntBiofuelSetV1.operationCode.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class}) String operationCode;
    @Pattern.List(value={@Pattern(regexp="1|4|6|7|8", message="{sntBiofuelSetV1.productSellerType.pattern}", groups={SntValidationGroups.ReturnedSnt.class}), @Pattern(regexp="1|4|6", message="{sntBiofuelSetV1.productSellerType.pattern}", groups={SntValidationGroups.PrimarySnt.class, SntValidationGroups.FixedSnt.class})})
    @RequiredString(required=false, minLen=1, maxLen=1, fieldPath="sntBiofuelSetV1.productSellerType")
    @XmlElement(required=false)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (G7 70)")
    private String productSellerType;
    @RequiredString(required=false, minLen=4, maxLen=4, fieldPath="sntBiofuelSetV1.kogdOfSender")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414 \u0430\u0434\u0440\u0435\u0441\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438/\u043e\u0442\u0433\u0440\u0443\u0437\u043a\u0438 (G7 71)")
    private String kogdOfSender;
    @RequiredString(required=false, minLen=4, maxLen=4, fieldPath="sntBiofuelSetV1.kogdOfRecipient")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438/\u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 (G7 72)")
    private String kogdOfRecipient;
    @Valid
    @XmlElementWrapper(name="products", required=true)
    @XmlElement(name="product", required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0431\u0438\u043e\u0442\u043e\u043f\u043b\u0438\u0432\u0443 (G7)")
    private List<SntBiofuelProductV1> products;

    @Override
    public String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public String getProductSellerType() {
        return this.productSellerType;
    }

    public void setProductSellerType(String productSellerType) {
        this.productSellerType = productSellerType;
    }

    public String getKogdOfSender() {
        return this.kogdOfSender;
    }

    public void setKogdOfSender(String kogdOfSender) {
        this.kogdOfSender = kogdOfSender;
    }

    public String getKogdOfRecipient() {
        return this.kogdOfRecipient;
    }

    public void setKogdOfRecipient(String kogdOfRecipient) {
        this.kogdOfRecipient = kogdOfRecipient;
    }

    public List<SntBiofuelProductV1> getProducts() {
        return this.products;
    }

    @Override
    public Boolean getFinalUserFlag() {
        return OPERATION_CODE_FINAL_USER.equals(this.operationCode);
    }

    public void setProducts(List<SntBiofuelProductV1> products) {
        this.products = products;
    }

    @Override
    public boolean isBaikonurShipping() {
        return OPERATION_CODE_BAIKONUR_SHIPPING_BIOFUEL.equals(this.getOperationCode());
    }

    @Override
    public boolean isFinalUser() {
        return OPERATION_CODE_FINAL_USER.equals(this.getOperationCode());
    }

    @Override
    public boolean isExciseProducts() {
        return true;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.BIOFUEL;
    }
}

