/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.Arrays;

public enum SntProductTypeV1 {
    PRODUCT("productSet.products", 1),
    ETHANOL("alcoholSet.ethanolProductSet.products", 2),
    WINE_MATERIAL("alcoholSet.wineMaterialProductSet.products", 3),
    BEER("alcoholSet.wineMaterialProductSet.products", 4),
    ALCOHOL_EXCEPT_BEER("alcoholSet.alcoholExceptBeerProductSet.products", 5),
    OIL("oilSet.products", 6),
    BIOFUEL("biofuelSet.products", 7),
    TOBACCO("tobaccoSet.products", 8),
    OTHER_PRODUCT_WITH_DIGITAL_MARK("otherProductWithDigitalMarkSet.products", 9),
    EXPORT_CONTROL_PRODUCT("exportControlProductSet.products", 10);

    private final String productsPath;
    private final int productSetIdx;

    private SntProductTypeV1(String productsPath, int productSetIdx) {
        this.productsPath = productsPath;
        this.productSetIdx = productSetIdx;
    }

    public String getProductsPath() {
        return this.productsPath;
    }

    public int getProductSetIdx() {
        return this.productSetIdx;
    }

    public static String findProductPath(int productSetIdx) {
        SntProductTypeV1 productTypeV1 = Arrays.stream(SntProductTypeV1.values()).filter(type -> type.getProductSetIdx() == productSetIdx).findFirst().orElse(null);
        return productTypeV1 == null ? null : productTypeV1.getProductsPath();
    }
}

