/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.transit.version.v1;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.transit.TaxpayerIdentifierHolder;
import ru.uss.esf.validation.transit.ImmutableForExport;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Carrier")
@Documentation(value="\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a \u0438 \u0430\u0432\u0442\u043e\u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442")
public class Carrier
implements TaxpayerIdentifierHolder {
    @Valid
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430")
    @ImmutableForExport
    @Size(min=1, max=50, message="{transit.carrier.identifier.size}")
    private @Valid @Size(min=1, max=50, message="{transit.carrier.identifier.size}") String identifier;
    @Documentation(value="\u041d\u0435\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442")
    @ImmutableForExport
    @Valid
    @NotNull(message="{transit.\u0441arrier.noResident.notNull}")
    @XmlElement(required=true)
    private @Valid @NotNull(message="{transit.\u0441arrier.noResident.notNull}") Boolean noResident = Boolean.FALSE;
    @Documentation(value="\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a")
    @NotEmpty(message="{transit.carrier.name.notEmpty}")
    @Size(min=1, max=150, message="{transit.carrier.name.size}")
    @XmlElement(required=true)
    private @NotEmpty(message="{transit.carrier.name.notEmpty}") @Size(min=1, max=150, message="{transit.carrier.name.size}") String name;
    @Documentation(value="\u0424\u0418\u041e \u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f \u0422\u0421")
    @NotEmpty(message="{transit.carrier.driverName.notEmpty}")
    @Size(min=1, max=150, message="{transit.carrier.driverName.size}")
    @XmlElement(required=true)
    private @NotEmpty(message="{transit.carrier.driverName.notEmpty}") @Size(min=1, max=150, message="{transit.carrier.driverName.size}") String driverName;
    @Valid
    @Documentation(value="\u041a\u043e\u0434 \u041e\u0413\u0414")
    @ImmutableForExport
    @Size(min=1, max=4, message="{transit.carrier.ogdCode.size}")
    @XmlElement
    private @Valid @Size(min=1, max=4, message="{transit.carrier.ogdCode.size}") String ogdCode;
    @Valid
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u041e\u0413\u0414")
    @ImmutableForExport
    @Size(min=1, max=500, message="{transit.carrier.ogdName.size}")
    @XmlElement
    private @Valid @Size(min=1, max=500, message="{transit.carrier.ogdName.size}") String ogdName;
    @Documentation(value="\u041c\u0430\u0440\u043a\u0430 \u0422\u0421")
    @NotEmpty(message="{transit.carrier.carModel.notEmpty}")
    @Size(min=1, max=100, message="{transit.carrier.carModel.size}")
    @XmlElement(required=true)
    private @NotEmpty(message="{transit.carrier.carModel.notEmpty}") @Size(min=1, max=100, message="{transit.carrier.carModel.size}") String carModel;
    @Documentation(value="\u0413\u043e\u0441.\u043d\u043e\u043c\u0435\u0440")
    @NotEmpty(message="{transit.carrier.carNumber.notEmpty}")
    @Size(min=1, max=20, message="{transit.carrier.carNumber.size}")
    @Pattern(regexp="[0-9A-Z]*", message="{transit.carrier.carNumber.format}")
    @XmlElement(required=true)
    private @NotEmpty(message="{transit.carrier.carNumber.notEmpty}") @Size(min=1, max=20, message="{transit.carrier.carNumber.size}") @Pattern(regexp="[0-9A-Z]*", message="{transit.carrier.carNumber.format}") String carNumber;
    @Documentation(value="\u0413\u043e\u0441.\u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0438\u0446\u0435\u043f\u0430")
    @Size(min=1, max=20, message="{transit.carrier.trailerNumber.size}")
    @Pattern(regexp="[0-9A-Z]*", message="{transit.carrier.trailerNumber.format}")
    private @Size(min=1, max=20, message="{transit.carrier.trailerNumber.size}") @Pattern(regexp="[0-9A-Z]*", message="{transit.carrier.trailerNumber.format}") String trailerNumber;
    @Documentation(value="\u041f\u043b\u043e\u043c\u0431\u0430")
    @Size(min=1, max=7, message="{transit.carrier.stamp.size}")
    @Pattern(regexp="[A-Za-z]{3}[0-9]{4}|[0-9]{4}", message="{transit.carrier.stamp.format}")
    private @Size(min=1, max=7, message="{transit.carrier.stamp.size}") @Pattern(regexp="[A-Za-z]{3}[0-9]{4}|[0-9]{4}", message="{transit.carrier.stamp.format}") String stamp;

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public Boolean getNoResident() {
        return this.noResident;
    }

    public void setNoResident(Boolean noResident) {
        this.noResident = noResident;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    @Override
    public String getOgdCode() {
        return this.ogdCode;
    }

    public void setOgdCode(String ogdCode) {
        this.ogdCode = ogdCode;
    }

    @Override
    public String getOgdName() {
        return this.ogdName;
    }

    public void setOgdName(String ogdName) {
        this.ogdName = ogdName;
    }

    public String getCarModel() {
        return this.carModel;
    }

    public void setCarModel(String carModel) {
        this.carModel = carModel;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }

    public String getTrailerNumber() {
        return this.trailerNumber;
    }

    public void setTrailerNumber(String trailerNumber) {
        this.trailerNumber = trailerNumber;
    }

    public String getStamp() {
        return this.stamp;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }
}

