/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.transit.version.v1;

import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.validation.transit.ImmutableForExport;
import ru.uss.esf.validation.transit.OneOfCostOrCostInCurrencyNeeded;
import ru.uss.esf.validation.transit.TransitVinCodeCheck;
import ru.uss.esf.validation.transit.ValidProductsCost;

@ValidProductsCost(message="{transit.products.costInCurrency.notNull}", fieldPath="products.costInCurrency")
@OneOfCostOrCostInCurrencyNeeded(message="{transit.products.costOrCostInCurrency.notNull}", fieldPath="products.cost")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Products")
@Documentation(value="\u0422\u043e\u0432\u0430\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u0434\u0435\u043b")
public class Products {
    @Documentation(value="\u0412\u0430\u043b\u044e\u0442\u0430")
    @ImmutableForExport
    @NotEmpty(message="{transit.products.currencyCode.notEmpty}")
    @XmlElement(required=true)
    private @NotEmpty(message="{transit.products.currencyCode.notEmpty}") String currencyCode;
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0432 \u0432\u0430\u043b\u044e\u0442\u0435")
    @ImmutableForExport
    @PositiveOrZero
    private BigDecimal costInCurrency;
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0432 \u0442\u0435\u043d\u0433\u0435")
    @ImmutableForExport
    @NotNull(message="{transit.products.cost.notNull}")
    @PositiveOrZero
    private @NotNull(message="{transit.products.cost.notNull}") BigDecimal cost;
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b")
    @ImmutableForExport
    @Valid
    @NotNull(message="{transit.products.products.notNull}")
    @Size(min=1, message="{transit.products.products.size}")
    private @Valid @NotNull(message="{transit.products.products.notNull}") @Size(min=1, message="{transit.products.products.size}") List<Product> products;

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getCostInCurrency() {
        return this.costInCurrency;
    }

    public void setCostInCurrency(BigDecimal costInCurrency) {
        this.costInCurrency = costInCurrency;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    @TransitVinCodeCheck(message="{transit.products.product.vinCode.notNull}", fieldPath="vinCode")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="Product")
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440")
    public static class Product {
        @ImmutableForExport
        @NotEmpty(message="{transit.products.products.tnved.notEmpty}")
        @XmlElement(required=true)
        @Documentation(value="\u041a\u043e\u0434 \u0422\u041d\u0412\u042d\u0414")
        private @NotEmpty(message="{transit.products.products.tnved.notEmpty}") String tnved;
        @ImmutableForExport
        @NotEmpty(message="{transit.products.products.name.notEmpty}")
        @Size(min=1, max=2500, message="{transit.products.products.name.size}")
        @XmlElement(required=true)
        @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430")
        private @NotEmpty(message="{transit.products.products.name.notEmpty}") @Size(min=1, max=2500, message="{transit.products.products.name.size}") String name;
        @Pattern(regexp="[ABCDEFGHJKLMNPRSTUVWXYZ0-9]{10,17}", message="{transit.products.product.vinCode.format}")
        @XmlElement(required=false)
        @Documentation(value="VIN-\u043a\u043e\u0434")
        private @Pattern(regexp="[ABCDEFGHJKLMNPRSTUVWXYZ0-9]{10,17}", message="{transit.products.product.vinCode.format}") String vinCode;
        @ImmutableForExport
        @NotNull(message="{transit.products.products.quantity.notNull}")
        @PositiveOrZero
        @XmlElement(required=true)
        @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e")
        private @NotNull(message="{transit.products.products.quantity.notNull}") BigDecimal quantity;
        @ImmutableForExport
        @NotEmpty(message="{transit.products.products.measureUnit.notEmpty}")
        @XmlElement(required=true)
        @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
        private @NotEmpty(message="{transit.products.products.measureUnit.notEmpty}") String measureUnit;
        @ImmutableForExport
        @PositiveOrZero
        @Documentation(value="\u0421\u0443\u043c\u043c\u0430")
        private BigDecimal amount;
        @ImmutableForExport
        @RequiredString(required=false, minLen=34, maxLen=34, fieldPath="transit.products.products.esfRegNumber")
        @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0439 \u042d\u0421\u0424")
        private String esfRegNumber;
        @ImmutableForExport
        @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f")
        private String countryOfOrigin;

        public String getTnved() {
            return this.tnved;
        }

        public void setTnved(String tnved) {
            this.tnved = tnved;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVinCode() {
            return this.vinCode;
        }

        public void setVinCode(String vinCode) {
            this.vinCode = vinCode;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        public String getMeasureUnit() {
            return this.measureUnit;
        }

        public void setMeasureUnit(String measureUnit) {
            this.measureUnit = measureUnit;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public String getEsfRegNumber() {
            return this.esfRegNumber;
        }

        public void setEsfRegNumber(String esfRegNumber) {
            this.esfRegNumber = esfRegNumber;
        }

        public String getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        public void setCountryOfOrigin(String countryOfOrigin) {
            this.countryOfOrigin = countryOfOrigin;
        }
    }
}

