/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.transit.version.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.esf.model.transit.Transit;
import ru.uss.esf.model.transit.TransitType;
import ru.uss.esf.model.transit.version.v1.Carrier;
import ru.uss.esf.model.transit.version.v1.Consignee;
import ru.uss.esf.model.transit.version.v1.Consignor;
import ru.uss.esf.model.transit.version.v1.Documents;
import ru.uss.esf.model.transit.version.v1.ExportData;
import ru.uss.esf.model.transit.version.v1.ImportData;
import ru.uss.esf.model.transit.version.v1.Products;
import ru.uss.esf.validation.transit.ImmutableForExport;
import ru.uss.esf.validation.transit.TransitCarrierCheck;
import ru.uss.esf.validation.transit.TransitTaxpayerOgdCheck;
import ru.uss.esf.validation.transit.TransitTypeValidationGroup;
import ru.uss.esf.validation.transit.ValidConsignee;
import ru.uss.esf.validation.transit.ValidConsignor;
import ru.uss.esf.validation.transit.ValidDocuments;
import ru.uss.esf.validation.transit.ValidProductsList;

@TransitTaxpayerOgdCheck
@TransitCarrierCheck
@ValidProductsList(message="{transit.products.notNull}", fieldPath="products")
@ValidConsignor(message="{transit.consignor.notNull}", fieldPath="consignor")
@ValidConsignee(message="{transit.consignee.notNull}", fieldPath="consignee")
@ValidDocuments(message="{transit.documents.notNull}", fieldPath="documents")
@XmlRootElement(name="transit")
@XmlType(name="TransitV1")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Documentation(value="\u0417\u0430\u043f\u0438\u0441\u044c \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 \u0422\u0440\u0430\u043d\u0437\u0438\u0442")
public class TransitV1
extends Transit {
    @ImmutableForExport
    @Valid
    @NotNull(message="{transit.type.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f")
    private @Valid @NotNull(message="{transit.type.notNull}") TransitType type;
    @ImmutableForExport
    @Valid
    @IsNotNull(message="{transit.importData.notNull}", groups={TransitTypeValidationGroup.ToImport.class})
    @XmlElement(required=false)
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0432\u043e\u0437\u0435")
    private ImportData importData;
    @Valid
    @IsNotNull(message="{transit.exportData.notNull}", groups={TransitTypeValidationGroup.ToExport.class, TransitTypeValidationGroup.ToExportWithViolations.class})
    @XmlElement(required=false)
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u044b\u0432\u043e\u0437\u0435")
    private ExportData exportData;
    @ImmutableForExport
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0413\u0440\u0443\u0437\u043e\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c")
    private Consignor consignor;
    @ImmutableForExport
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0413\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c")
    private Consignee consignee;
    @ImmutableForExport
    @Valid
    @NotNull(message="{transit.carrier.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a \u0438 \u0430\u0432\u0442\u043e\u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442")
    private @Valid @NotNull(message="{transit.carrier.notNull}") Carrier carrier;
    @ImmutableForExport
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a \u0438 \u0430\u0432\u0442\u043e\u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442 2")
    private Carrier carrier2;
    @ImmutableForExport
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043e\u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b")
    private Documents documents;
    @ImmutableForExport
    @Valid
    @XmlElement(required=false)
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u0434\u0435\u043b")
    private Products products;
    @ImmutableForExport
    @Size(min=1, max=1000, message="{transit.additionalInfo.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f")
    private @Size(min=1, max=1000, message="{transit.additionalInfo.size}") String additionalInfo;
    @Size(min=1, max=500, message="{transit.violationInfo.size}")
    @IsNotNull(message="{transit.violationInfo.notNull}", groups={TransitTypeValidationGroup.ToExportWithViolations.class})
    @Documentation(value="\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435")
    private @Size(min=1, max=500, message="{transit.violationInfo.size}") String violationInfo;
    @Size(min=1, max=500, message="{transit.cancelReason.size}")
    @IsNotNull(message="{transit.cancelReason.notNull}", groups={TransitTypeValidationGroup.ToCancel.class})
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u044b")
    private @Size(min=1, max=500, message="{transit.cancelReason.size}") String cancelReason;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0443\u0441\u0442\u043e\u0439 \u0410\u0422\u0421")
    private Boolean withoutProducts;
    @XmlTransient
    @JsonIgnore
    private boolean carrierInfoEdit = false;

    public TransitType getType() {
        return this.type;
    }

    public void setType(TransitType type) {
        this.type = type;
    }

    public ImportData getImportData() {
        return this.importData;
    }

    public void setImportData(ImportData importData) {
        this.importData = importData;
    }

    public ExportData getExportData() {
        return this.exportData;
    }

    public void setExportData(ExportData exportData) {
        this.exportData = exportData;
    }

    public Consignor getConsignor() {
        return this.consignor;
    }

    public void setConsignor(Consignor consignor) {
        this.consignor = consignor;
    }

    public Consignee getConsignee() {
        return this.consignee;
    }

    public void setConsignee(Consignee consignee) {
        this.consignee = consignee;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Carrier carrier) {
        this.carrier = carrier;
    }

    public Carrier getCarrier2() {
        return this.carrier2;
    }

    public void setCarrier2(Carrier carrier2) {
        this.carrier2 = carrier2;
    }

    public Documents getDocuments() {
        return this.documents;
    }

    public void setDocuments(Documents documents) {
        this.documents = documents;
    }

    public Products getProducts() {
        return this.products;
    }

    public void setProducts(Products products) {
        this.products = products;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getViolationInfo() {
        return this.violationInfo;
    }

    public void setViolationInfo(String violationInfo) {
        this.violationInfo = violationInfo;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public Boolean getWithoutProducts() {
        return this.withoutProducts;
    }

    public void setWithoutProducts(Boolean withoutProducts) {
        this.withoutProducts = withoutProducts;
    }

    @Override
    public boolean isCarrierInfoEdit() {
        return this.carrierInfoEdit;
    }

    @Override
    public void setCarrierInfoEdit(boolean carrierInfoEdit) {
        this.carrierInfoEdit = carrierInfoEdit;
    }
}

