/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.usermng;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.ClientType;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.registration.Project;
import ru.uss.esf.model.registration.ProjectParticipantType;
import ru.uss.esf.model.usermng.ArmUser;
import ru.uss.esf.model.usermng.BusinessProfileType;
import ru.uss.esf.model.usermng.BusinessUser;
import ru.uss.esf.model.usermng.User;

public class UserProfileInfo
implements Serializable {
    @JsonIgnore
    private User user;
    private String login;
    private String tin;
    private ProjectParticipantType projectParticipantType;
    private BusinessProfileType businessProfileType;
    private String projectParticipantTin;
    private boolean projectParticipantIsActive;
    private Long projectCode;
    private String headTin;
    private ClientType clientType;

    public UserProfileInfo() {
    }

    public UserProfileInfo(String login, String tin) {
        this.login = login;
        this.tin = tin;
    }

    public UserProfileInfo(String login, String tin, ClientType clientType) {
        this.login = login;
        this.tin = tin;
        this.clientType = clientType;
    }

    public UserProfileInfo(ProjectParticipantType projectParticipantType, String projectParticipantTin, boolean projectParticipantIsActive, Long projectCode) {
        this.projectParticipantType = projectParticipantType;
        this.projectParticipantTin = projectParticipantTin;
        this.projectParticipantIsActive = projectParticipantIsActive;
        this.projectCode = projectCode;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @JsonIgnore
    public ArmUser getArmUser() {
        if (this.user != null) {
            return this.user.getArmUser();
        }
        return null;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public ProjectParticipantType getProjectParticipantType() {
        return this.projectParticipantType;
    }

    public void setProjectParticipantType(ProjectParticipantType projectParticipantType) {
        this.projectParticipantType = projectParticipantType;
    }

    public BusinessProfileType getBusinessProfileType() {
        return this.businessProfileType;
    }

    public void setBusinessProfileType(BusinessProfileType businessProfileType) {
        this.businessProfileType = businessProfileType;
    }

    public String getProjectParticipantTin() {
        return this.projectParticipantTin;
    }

    public void setProjectParticipantTin(String projectParticipantTin) {
        this.projectParticipantTin = projectParticipantTin;
    }

    public boolean isProjectParticipantIsActive() {
        return this.projectParticipantIsActive;
    }

    public void setProjectParticipantIsActive(boolean projectParticipantIsActive) {
        this.projectParticipantIsActive = projectParticipantIsActive;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public String getHeadTin() {
        return this.headTin;
    }

    public void setHeadTin(String headTin) {
        this.headTin = headTin;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public boolean isAttorney() {
        return this.projectParticipantType == ProjectParticipantType.ATTORNEY;
    }

    public boolean isTruster() {
        return this.projectParticipantType == ProjectParticipantType.TRUSTER;
    }

    public boolean isOperator() {
        return this.projectParticipantType == ProjectParticipantType.OPERATOR;
    }

    public boolean isContractor() {
        return this.projectParticipantType == ProjectParticipantType.CONTRACTOR;
    }

    public boolean isIndividual() {
        return BusinessProfileType.INDIVIDUAL.equals((Object)this.businessProfileType);
    }

    public DocumentParticipantType getDocumentParticipantType() {
        if (this.businessProfileType != null) {
            return this.businessProfileType.getParticipantType();
        }
        return DocumentParticipantType.BUSINESS;
    }

    public String getCurrentTin() {
        if (this.tin == null && this.projectCode != null) {
            return this.projectParticipantTin;
        }
        return this.tin;
    }

    public String toString() {
        return "UserProfileInfo{login='" + this.login + '\'' + ", tin='" + this.tin + '\'' + ", projectParticipantType=" + (Object)((Object)this.projectParticipantType) + ", businessProfileType=" + (Object)((Object)this.businessProfileType) + ", projectParticipantTin='" + this.projectParticipantTin + '\'' + ", projectParticipantIsActive=" + this.projectParticipantIsActive + ", projectCode=" + this.projectCode + ", headTin='" + this.headTin + '\'' + ", clientType=" + (Object)((Object)this.clientType) + '}';
    }

    public static UserProfileInfo create(BusinessUser profile, Project project) {
        return UserProfileInfo.create(profile, project, null);
    }

    public static UserProfileInfo create(BusinessUser profile, Project project, ClientType clientType) {
        UserProfileInfo userProfileInfo = project == null ? new UserProfileInfo(profile.getIin(), profile.getTin()) : new UserProfileInfo(profile.getProjectParticipantType(), profile.getTin(), profile.isActive(), profile.getProjectCode());
        if (profile.getEnterpriseTaxpayerInfo() != null && profile.getEnterpriseTaxpayerInfo().getHeadOffice() != null && !StringUtils.isEmpty((CharSequence)profile.getEnterpriseTaxpayerInfo().getHeadOffice().getTin())) {
            userProfileInfo.setHeadTin(profile.getEnterpriseTaxpayerInfo().getHeadOffice().getTin());
        }
        userProfileInfo.setBusinessProfileType(profile.getBusinessProfileType());
        userProfileInfo.setClientType(clientType);
        return userProfileInfo;
    }

    public UserProfileInfo cloneProfile() {
        UserProfileInfo clone = new UserProfileInfo();
        clone.setLogin(this.login);
        clone.setTin(this.tin);
        clone.setProjectParticipantType(this.projectParticipantType);
        clone.setBusinessProfileType(this.businessProfileType);
        clone.setProjectParticipantTin(this.projectParticipantTin);
        clone.setProjectParticipantIsActive(this.projectParticipantIsActive);
        clone.setProjectCode(this.projectCode);
        clone.setHeadTin(this.headTin);
        clone.setClientType(this.clientType);
        return clone;
    }
}

