/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.ArrayList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.AllNotEmptyOrEmpty;

public class AllNotEmptyOrEmptyValidator
implements ConstraintValidator<AllNotEmptyOrEmpty, Object> {
    private String[] fields;
    private String[] errorNodes;
    private String message;

    public void initialize(AllNotEmptyOrEmpty constraintAnnotation) {
        this.fields = constraintAnnotation.fields();
        this.errorNodes = constraintAnnotation.errorNodes();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (object == null) {
            return true;
        }
        int emptyCount = 0;
        ArrayList<PathInfo> pathList = new ArrayList<PathInfo>();
        for (String field : this.fields) {
            PathInfo pathInfo = new PathInfo();
            if (!FieldUtils.fieldNotEmpty(object, field, pathInfo)) {
                ++emptyCount;
            }
            pathList.add(pathInfo);
        }
        if (emptyCount == 0 || emptyCount == this.fields.length) {
            return true;
        }
        if (this.errorNodes.length > 0) {
            for (String errorNode : this.errorNodes) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(errorNode).addConstraintViolation();
            }
        } else {
            for (PathInfo pathInfo : pathList) {
                for (String path : pathInfo.getPaths()) {
                    context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
                }
            }
        }
        return false;
    }
}

