/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.DatePeriod;

public class DatePeriodValidator
implements ConstraintValidator<DatePeriod, Object> {
    private String startDateField;
    private String endDateField;
    private String message;
    private String[] errorNodes;

    public void initialize(DatePeriod constraintAnnotation) {
        this.startDateField = constraintAnnotation.startDateField();
        this.endDateField = constraintAnnotation.endDateField();
        this.message = constraintAnnotation.message();
        this.errorNodes = constraintAnnotation.errorNodes();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (FieldUtils.fieldNotEmpty(object, this.startDateField) && FieldUtils.fieldNotEmpty(object, this.endDateField)) {
            Date endDate;
            PathInfo pathInfo = new PathInfo();
            Date startDate = (Date)FieldUtils.getFieldValue(object, this.startDateField);
            if (startDate.compareTo(endDate = (Date)FieldUtils.getFieldValue(object, this.endDateField)) > 0) {
                if (this.errorNodes.length > 0) {
                    for (String errorNode : this.errorNodes) {
                        context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(errorNode).addConstraintViolation();
                    }
                } else {
                    context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.startDateField).addConstraintViolation();
                }
                return false;
            }
        }
        return true;
    }
}

