/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.validation.common.relation.Lists;

public class ListsValidator
implements ConstraintValidator<Lists, Object> {
    private String[] lists;
    private Lists.Constraint constraint;
    private String field;
    private String[] errorNodes;
    private String message;

    public void initialize(Lists constraintAnnotation) {
        this.lists = constraintAnnotation.lists();
        this.constraint = constraintAnnotation.constraint();
        this.field = constraintAnnotation.field();
        this.errorNodes = constraintAnnotation.errorNodes();
        this.message = constraintAnnotation.message();
        if (this.lists.length > 2) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        if (object == null) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            switch (this.constraint) {
                case NOT_EMPTY_ELEMENTS: {
                    for (Object e : list) {
                        if (e != null && FieldUtils.fieldNotEmpty(e, this.field)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new IllegalStateException("Invalid constraint");
        }
        Set<?> set1 = this.toSet(object, this.lists[0]);
        Set<?> set2 = this.toSet(object, this.lists[1]);
        if (set1 == null || set2 == null) {
            return true;
        }
        switch (this.constraint) {
            case EQUALS_SETS: {
                if (!set1.equals(set2)) {
                    this.addErrorPaths(context);
                    return false;
                }
                return true;
            }
            case DISJOINT_SETS: {
                if (set1.removeAll(set2)) {
                    this.addErrorPaths(context);
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Invalid constraint");
    }

    private void addErrorPaths(ConstraintValidatorContext context) {
        if (this.errorNodes.length > 0) {
            context.disableDefaultConstraintViolation();
            for (String errorNode : this.errorNodes) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(errorNode).addConstraintViolation();
            }
        }
    }

    private Set<?> toSet(Object object, String path) {
        List list = (List)FieldUtils.getFieldValue(object, path);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashSet set = new HashSet();
        for (Object e : list) {
            if (e == null) {
                set.add(null);
                continue;
            }
            Object fieldValue = this.field.isEmpty() ? e : FieldUtils.getFieldValue(e, this.field);
            set.add(fieldValue);
        }
        return set;
    }
}

