/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;

public class NotEmptyIfTargetFieldContainsValidator
implements ConstraintValidator<NotEmptyIfTargetFieldContains, Object> {
    private String checkedField;
    private String targetField;
    private List<String> expectedValues;
    private String message;

    public void initialize(NotEmptyIfTargetFieldContains constraintAnnotation) {
        this.checkedField = constraintAnnotation.checkedField();
        this.targetField = constraintAnnotation.targetField();
        this.expectedValues = Arrays.asList(constraintAnnotation.expectedValues());
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        Object targetFieldValue = FieldUtils.getFieldValue(object, this.targetField);
        if (targetFieldValue != null) {
            if (targetFieldValue instanceof Collection) {
                Collection targetCollection = (Collection)targetFieldValue;
                for (Object collectionElement : targetCollection) {
                    if (!this.expectedValues.stream().anyMatch(value -> Objects.equals(value, Objects.toString(collectionElement, null)))) continue;
                    return this.checkEmpty(object, context);
                }
                return true;
            }
            if (!targetFieldValue.toString().isEmpty() && this.expectedValues.contains(targetFieldValue.toString())) {
                return this.checkEmpty(object, context);
            }
        }
        return true;
    }

    private boolean checkEmpty(Object object, ConstraintValidatorContext context) {
        PathInfo pathInfo = new PathInfo();
        if (!FieldUtils.fieldNotEmpty(object, this.checkedField, pathInfo)) {
            for (String path : pathInfo.getPaths()) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

