/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.TextLengthIfTagretFieldContains;

public class TextLengthIfTagretFieldContainsValidator
implements ConstraintValidator<TextLengthIfTagretFieldContains, Object> {
    private int min;
    private int max;
    private String checkedField;
    private String targetField;
    private String expectedValue;
    private String message;

    public void initialize(TextLengthIfTagretFieldContains constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        if (this.min <= 0) {
            throw new IllegalStateException("Min text size can not be 0 or lower");
        }
        this.checkedField = constraintAnnotation.checkedField();
        this.targetField = constraintAnnotation.targetField();
        this.expectedValue = constraintAnnotation.expectedValue();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        Object targetFieldValue = FieldUtils.getFieldValue(object, this.targetField);
        if (targetFieldValue != null) {
            if (targetFieldValue instanceof Collection) {
                Collection targetCollection = (Collection)targetFieldValue;
                for (Object collectionElement : targetCollection) {
                    if (!this.expectedValue.toString().equals(collectionElement.toString())) continue;
                    return this.checkLength(object, context);
                }
                return true;
            }
            if (!targetFieldValue.toString().isEmpty() && this.expectedValue.equals(targetFieldValue.toString())) {
                return this.checkLength(object, context);
            }
        }
        return true;
    }

    protected boolean checkLength(Object object, ConstraintValidatorContext context) {
        Object checkedFieldValue;
        PathInfo pathInfo = new PathInfo();
        if (FieldUtils.fieldNotEmpty(object, this.checkedField, pathInfo) && ((checkedFieldValue = FieldUtils.getFieldValue(object, this.checkedField)).toString().length() < this.min || checkedFieldValue.toString().length() > this.max)) {
            for (String path : pathInfo.getPaths()) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

