/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.math.BigDecimal;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.validation.common.relation.TotalOf;

public class TotalOfValidator
implements ConstraintValidator<TotalOf, Object> {
    private String field;
    private String column;
    private String message;
    private boolean nullAsZero;

    public void initialize(TotalOf constraintAnnotation) {
        this.field = constraintAnnotation.field();
        this.column = constraintAnnotation.column();
        this.message = constraintAnnotation.message();
        this.nullAsZero = constraintAnnotation.nullAsZero();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        List list = (List)FieldUtils.getFieldValue(value, this.column.split("\\.")[0]);
        Object fieldValue = FieldUtils.getFieldValue(value, this.field);
        if (fieldValue == null && this.nullAsZero) {
            fieldValue = BigDecimal.ZERO;
        }
        if (list == null || list.isEmpty() || fieldValue == null) {
            return true;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); ++i) {
            Object listElement = list.get(i);
            if (listElement == null) {
                return true;
            }
            BigDecimal cellValue = (BigDecimal)FieldUtils.getFieldValue(listElement, this.column.split("\\.")[1]);
            if (cellValue == null && this.nullAsZero) {
                cellValue = BigDecimal.ZERO;
            }
            if (cellValue == null) {
                return true;
            }
            total = total.add(cellValue);
        }
        if (total.compareTo((BigDecimal)fieldValue) == 0) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.field).addConstraintViolation();
        return false;
    }
}

