/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.LinkedList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.version.v1.EcontractProductV1;
import ru.uss.esf.model.econtract.version.v1.EcontractStageV1;
import ru.uss.esf.model.econtract.version.v1.EcontractV1;
import ru.uss.esf.validation.econtract.version.v1.EcontractCurrencyConsistencyV1;

public class EcontractCurrencyConsistencyValidatorV1
extends AbstractClassLevelValidator<EcontractCurrencyConsistencyV1, EcontractV1> {
    public void initialize(EcontractCurrencyConsistencyV1 econtractCurrencyConsistencyV1) {
        this.annotation = econtractCurrencyConsistencyV1;
    }

    public boolean isValid(EcontractV1 econtractV1, ConstraintValidatorContext context) {
        if (econtractV1 == null) {
            return true;
        }
        if (econtractV1.getCurrency() == null || BooleanUtils.isTrue((Boolean)econtractV1.getCurrency().getMultiCurrency())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)econtractV1.getCurrency().getCurrencyCode())) {
            return true;
        }
        String econtractCurrencyCode = econtractV1.getCurrency().getCurrencyCode();
        LinkedList<String> invalidProperties = new LinkedList<String>();
        if (!CollectionUtils.isEmpty(econtractV1.getStages())) {
            for (int stageIndex = 0; stageIndex < econtractV1.getStages().size(); ++stageIndex) {
                EcontractStageV1 stageV1 = econtractV1.getStages().get(stageIndex);
                if (CollectionUtils.isEmpty(stageV1.getProducts())) continue;
                for (int productIndex = 0; productIndex < stageV1.getProducts().size(); ++productIndex) {
                    EcontractProductV1 productV1 = stageV1.getProducts().get(productIndex);
                    if (this.isValidCurrencyCode(productV1, econtractCurrencyCode)) continue;
                    invalidProperties.add(String.format("econtract.stages[%d].products[%d].currencyCode", stageIndex, productIndex));
                }
            }
        }
        if (!CollectionUtils.isEmpty(invalidProperties)) {
            invalidProperties.forEach(property -> this.addConstraintViolation(context, (String)property, ((EcontractCurrencyConsistencyV1)this.annotation).message()));
            return false;
        }
        return true;
    }

    protected boolean isValidCurrencyCode(EcontractProductV1 productV1, String expectedCurrencyCode) {
        if (productV1 != null && StringUtils.isNotBlank((CharSequence)productV1.getCurrencyCode())) {
            return expectedCurrencyCode.equals(productV1.getCurrencyCode());
        }
        return false;
    }
}

