/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.clazz;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.version.EsfVersion;
import ru.uss.esf.model.invoice.version.EsfVersions;
import ru.uss.esf.model.invoice.version.InvoiceVersionMapper;
import ru.uss.esf.validation.invoice.clazz.VersionsDate;

public class VersionsDateValidator
implements ConstraintValidator<VersionsDate, AbstractInvoice> {
    public void initialize(VersionsDate constraintAnnotation) {
    }

    public boolean isValid(AbstractInvoice invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        Date invoiceDate = invoice.getTurnoverDate();
        String invoiceVersion = InvoiceVersionMapper.getVersionByClass(invoice);
        EsfVersion esfVersion = EsfVersions.getEsfVersion(invoiceVersion);
        if (invoice.getRelatedInvoice() == null && invoiceDate != null && invoiceVersion != null && (invoiceDate.compareTo(esfVersion.getStartDate()) < 0 || esfVersion.getEndDate() != null && invoiceDate.compareTo(esfVersion.getEndDate()) > 0)) {
            context.buildConstraintViolationWithTemplate("{invoice.version.date.range.invalid}").addPropertyNode("turnoverDate").addConstraintViolation();
            return false;
        }
        return true;
    }
}

