/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.CustomerV1;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.validation.invoice.version.v1.CustomerCountryCodeV1;

public class CustomerCountryCodeValidatorV1
implements ConstraintValidator<CustomerCountryCodeV1, InvoiceV1> {
    public static final String START_VALIDATE_DATE = "21.12.2015";
    public static Date validateFromDate;

    public void initialize(CustomerCountryCodeV1 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getDate() != null && invoice.getDate().compareTo(validateFromDate) != 1) {
            return true;
        }
        if (invoice.getCustomers() == null || invoice.getCustomers().size() != 1) {
            return true;
        }
        if (invoice.getSellers() == null) {
            return true;
        }
        CustomerV1 customer = invoice.getCustomers().get(0);
        if (customer.getStatuses() == null) {
            return true;
        }
        boolean sellerIsExporter = invoice.isForExport();
        boolean customerIsNonResident = invoice.isCustomerNonResident();
        if (customerIsNonResident && sellerIsExporter) {
            if (customer.getCountryCode() == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV1.customers.countryCode.isNull}").addPropertyNode("customers[0].countryCode").addConstraintViolation();
                return false;
            }
        } else if (customer.getCountryCode() != null) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.customers.countryCode.isNotNull}").addPropertyNode("customers[0].countryCode").addConstraintViolation();
            return false;
        }
        return true;
    }

    static {
        try {
            validateFromDate = new SimpleDateFormat("dd.MM.yyyy").parse(START_VALIDATE_DATE);
        }
        catch (ParseException e) {
            e.printStackTrace();
            validateFromDate = new Date();
        }
    }
}

