/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.validation.invoice.version.v1.ExportersV1;

public class ExportersValidatorV1
implements ConstraintValidator<ExportersV1, InvoiceV1> {
    public void initialize(ExportersV1 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        boolean isRateSet;
        context.disableDefaultConstraintViolation();
        if (invoice.getSellers() == null || invoice.getProductSet() == null || invoice.getProductSet().getCurrencyCode() == null) {
            return true;
        }
        boolean isExporter = invoice.isForExport();
        boolean bl = isRateSet = invoice.getProductSet().getCurrencyRate() != null && invoice.getProductSet().getCurrencyRate().compareTo(BigDecimal.ZERO) != 0;
        if (this.isCurrencyKzt(invoice) && isRateSet) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.products.currencyRate.exists}").addPropertyNode("productSet.currencyRate").addConstraintViolation();
            return false;
        }
        if (!isExporter && !this.isCurrencyKzt(invoice)) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.products.currencyCode.invalid}").addPropertyNode("productSet.currencyCode").addConstraintViolation();
            return false;
        }
        if (isExporter && !this.isCurrencyKzt(invoice) && !isRateSet) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.products.currencyRate.invalid}").addPropertyNode("productSet.currencyRate").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isCurrencyKzt(InvoiceV1 invoice) {
        return invoice.getProductSet().getCurrencyCode().equals("KZT");
    }
}

