/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.SellerTypeV1;
import ru.uss.esf.model.invoice.version.v1.SellerV1;
import ru.uss.esf.validation.invoice.version.v1.SellersParticipantsV1;

public class SellersParticipantsValidatorV1
implements ConstraintValidator<SellersParticipantsV1, List<SellerV1>> {
    public void initialize(SellersParticipantsV1 constraintAnnotation) {
    }

    public boolean isValid(List<SellerV1> sellers, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (sellers == null || sellers.isEmpty()) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.sellers.notEmpty}").addConstraintViolation();
            return false;
        }
        ArrayList<String> tins = new ArrayList<String>();
        for (int i = 0; i < sellers.size(); ++i) {
            SellerV1 seller = sellers.get(i);
            if (seller == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV1.sellers.elementIsNull}").addConstraintViolation();
                return false;
            }
            if (sellers.size() == 1) {
                if (seller.getStatuses() != null && seller.getStatuses().contains(SellerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                    context.buildConstraintViolationWithTemplate("{invoiceV1.sellers.singleIsNotParticipant}").addConstraintViolation();
                    return false;
                }
            } else if (seller.getStatuses() == null || !seller.getStatuses().contains(SellerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{invoiceV1.sellers.oneIsNotParticipant}").addConstraintViolation();
                return false;
            }
            tins.add(seller.getTin());
        }
        if (tins.size() != new HashSet(tins).size()) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.sellers.duplicatedTin}").addConstraintViolation();
            return false;
        }
        return true;
    }
}

