/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.InvoiceVersionHelper;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.NdsRateTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.CustomerCountryCodeV2;

public class CustomerCountryCodeValidatorV2
implements ConstraintValidator<CustomerCountryCodeV2, InvoiceV2> {
    public void initialize(CustomerCountryCodeV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getCustomers() == null) {
            return true;
        }
        if (invoice.getSellers() == null) {
            return true;
        }
        boolean withoutNdsNotKz = false;
        if (invoice.getProductSet() != null) {
            withoutNdsNotKz = NdsRateTypeV2.WITHOUT_NDS_NOT_KZ.equals((Object)invoice.getProductSet().getNdsRateType());
        }
        boolean sellerIsExporter = invoice.isForExport();
        int i = 0;
        for (CustomerV2 customer : invoice.getCustomers()) {
            Set sellerTypeV2Set;
            if (customer.getCountryCode() == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.countryCode.isNull}").addPropertyNode(String.format("customers[%d].countryCode", i)).addConstraintViolation();
                return false;
            }
            if (!(withoutNdsNotKz || "KZ".equals(customer.getCountryCode()) || (sellerTypeV2Set = invoice.getSellers().stream().filter(s -> s.getStatuses() != null).flatMap(s -> s.getStatuses().stream()).collect(Collectors.toSet())).contains(SellerTypeV2.EXPORTER) || sellerTypeV2Set.contains(SellerTypeV2.TRANSPORTER) || sellerTypeV2Set.contains(SellerTypeV2.FORWARDER) || InvoiceVersionHelper.deliveryDocContainsSnt(invoice))) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.countryCode.foreignCountryForLocalSell}").addPropertyNode(String.format("customers[%d].countryCode", i)).addConstraintViolation();
                return false;
            }
            ++i;
        }
        return true;
    }
}

