/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.PaperDateV2;

public class PaperDateValidatorV2
implements ConstraintValidator<PaperDateV2, InvoiceV2> {
    public void initialize(PaperDateV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        Date turnoverDate;
        context.disableDefaultConstraintViolation();
        if (invoice.getDatePaper() == null) {
            return true;
        }
        Date currentDate = DateTimeUtils.startOfTheDay(new Date());
        Date paperDate = DateTimeUtils.startOfTheDay(invoice.getDatePaper());
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(1, -5);
        Date dateMinus5Years = cal.getTime();
        if (paperDate.compareTo(currentDate) >= 0) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.paperDate.future}").addPropertyNode("datePaper").addConstraintViolation();
            return false;
        }
        if (invoice.getTurnoverDate() == null) {
            return true;
        }
        if (!(invoice.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE || !(turnoverDate = DateTimeUtils.startOfTheDay(invoice.getTurnoverDate())).after(paperDate) || invoice.isForExport() && invoice.isCustomerNonResident())) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.turnoverDate.after.paperDate}").addPropertyNode("turnoverDate").addConstraintViolation();
            return false;
        }
        return true;
    }
}

