/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;
import ru.uss.esf.validation.invoice.version.v2.ParticipantsV2;

public class ParticipantsValidatorV2
implements ConstraintValidator<ParticipantsV2, InvoiceV2> {
    public void initialize(ParticipantsV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        int i;
        context.disableDefaultConstraintViolation();
        if (invoice.getSellers() == null || invoice.getCustomers() == null) {
            return true;
        }
        for (i = 0; i < invoice.getSellers().size(); ++i) {
            if (!CollectionUtils.isNotEmpty(invoice.getSellers().get(i).getStatuses()) || !CollectionUtils.containsAny(invoice.getSellers().get(i).getStatuses(), (Object[])new SellerTypeV2[]{SellerTypeV2.LAWYER, SellerTypeV2.BAILIFF, SellerTypeV2.MEDIATOR, SellerTypeV2.NOTARY}) || invoice.getSellers().get(i).getStatuses().size() <= 1 || CollectionUtils.isEqualCollection(invoice.getSellers().get(i).getStatuses(), Arrays.asList(SellerTypeV2.LAWYER, SellerTypeV2.COMMITTENT))) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.privatePracticeStatus.notExclusive}").addPropertyNode("sellers[" + i + "].statuses").addConstraintViolation();
            return false;
        }
        for (i = 0; i < invoice.getCustomers().size(); ++i) {
            if (!CollectionUtils.isNotEmpty(invoice.getCustomers().get(i).getStatuses()) || !CollectionUtils.containsAny(invoice.getCustomers().get(i).getStatuses(), (Object[])new CustomerTypeV2[]{CustomerTypeV2.LAWYER, CustomerTypeV2.BAILIFF, CustomerTypeV2.MEDIATOR, CustomerTypeV2.NOTARY}) || invoice.getCustomers().get(i).getStatuses().size() <= 1) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV2.customers.privatePracticeStatus.notExclusive}").addPropertyNode("customers[" + i + "].statuses").addConstraintViolation();
            return false;
        }
        if (this.hasStatus(invoice.getSellers(), SellerTypeV2.JOINT_ACTIVITY_PARTICIPANT) && invoice.getSellers().size() <= 1) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.participants.join.sharing.count}").addConstraintViolation();
            return false;
        }
        if (invoice.getSellers().size() > 1) {
            for (i = 0; i < invoice.getSellers().size(); ++i) {
                if (invoice.getSellers().get(i).getShareParticipation() != null) continue;
                context.buildConstraintViolationWithTemplate("{sellerV2.shareParticipation.notNull}").addPropertyNode("sellers[" + i + "].shareParticipation").addConstraintViolation();
                return false;
            }
        }
        if (invoice.getCustomers().size() > 1) {
            for (i = 0; i < invoice.getCustomers().size(); ++i) {
                if (invoice.getCustomers().get(i).getShareParticipation() != null) continue;
                context.buildConstraintViolationWithTemplate("{customerV2.shareParticipation.notNull}").addPropertyNode("customers[" + i + "].shareParticipation").addConstraintViolation();
                return false;
            }
        }
        if (invoice.getSellers().stream().anyMatch(seller -> !CollectionUtils.isEmpty(seller.getStatuses()) && seller.getStatuses().contains(SellerTypeV2.LESSOR)) || invoice.getCustomers().stream().anyMatch(customer -> !CollectionUtils.isEmpty(customer.getStatuses()) && customer.getStatuses().contains(CustomerTypeV2.LESSEE))) {
            for (i = 0; i < invoice.getSellers().size(); ++i) {
                SellerV2 seller2 = invoice.getSellers().get(i);
                if (seller2.getStatuses() != null && seller2.getStatuses().contains(SellerTypeV2.LESSOR)) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.lessor.notSet}").addPropertyNode("sellers[" + i + "].statuses").addConstraintViolation();
                return false;
            }
            for (i = 0; i < invoice.getCustomers().size(); ++i) {
                CustomerV2 customer2 = invoice.getCustomers().get(i);
                if (customer2.getStatuses() != null && customer2.getStatuses().contains(CustomerTypeV2.LESSEE)) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.lessee.notSet}").addPropertyNode("customers[" + i + "].statuses").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    private boolean hasStatus(List<SellerV2> sellerList, SellerTypeV2 ... sellerTypes) {
        Set sellerTypeSet = sellerList.stream().filter(s -> s.getStatuses() != null && s.getStatuses().size() > 0).flatMap(s -> s.getStatuses().stream()).collect(Collectors.toSet());
        for (SellerTypeV2 sellerTypeV2 : sellerTypes) {
            if (!sellerTypeSet.contains(sellerTypeV2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStatus(List<CustomerV2> customerList, CustomerTypeV2 ... customerTypes) {
        Set customerTypeSet = customerList.stream().filter(s -> s.getStatuses() != null && s.getStatuses().size() > 0).flatMap(s -> s.getStatuses().stream()).collect(Collectors.toSet());
        for (CustomerTypeV2 customerTypeV2 : customerTypes) {
            if (!customerTypeSet.contains(customerTypeV2)) continue;
            return true;
        }
        return false;
    }
}

