/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.validation.invoice.version.v2.ProductNumberInDeclarationV2;

public class ProductNumberInDeclarationValidatorV2
implements ConstraintValidator<ProductNumberInDeclarationV2, ProductV2> {
    private static final Pattern PRODUCT_NUMBER_SHORT_PATTERN = Pattern.compile("^[0-9]{1,5}$");
    private static final Pattern PRODUCT_NUMBER_FULL_PATTERN = Pattern.compile("^[0-9]{1,5}(/[0-9]{1,5})?$");

    public void initialize(ProductNumberInDeclarationV2 constraintAnnotation) {
    }

    public boolean isValid(ProductV2 product, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (StringUtils.isEmpty((CharSequence)product.getProductNumberInDeclaration())) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)product.getProductDeclaration()) && (this.isValidDtNum(product.getProductDeclaration()) || RegistrationNumberUtils.isSnt(product.getProductDeclaration()))) {
            if (!PRODUCT_NUMBER_FULL_PATTERN.matcher(product.getProductNumberInDeclaration()).matches()) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.product.productNumberInDeclaration.withDT.wrongFormat}").addPropertyNode("productNumberInDeclaration").addConstraintViolation();
                return false;
            }
        } else if (!PRODUCT_NUMBER_SHORT_PATTERN.matcher(product.getProductNumberInDeclaration()).matches()) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productNumberInDeclaration.withoutDT.wrongFormat}").addPropertyNode("productNumberInDeclaration").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isValidDtNum(String dtNum) {
        return dtNum != null && dtNum.length() == 20 && Pattern.matches("[0-9]{5}/[0-9]{6}/[012]{1}[0-9]{6}", dtNum) && DateTimeUtils.isDateValid(dtNum.substring(6, 12), "ddMMyy");
    }
}

