/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.version.v2.ParticipantV2;
import ru.uss.esf.model.invoice.version.v2.ProductShareV2;
import ru.uss.esf.validation.invoice.version.v2.ProductShareNumberV2;

public class ProductShareNumberValidatorV2
implements ConstraintValidator<ProductShareNumberV2, ParticipantV2> {
    public void initialize(ProductShareNumberV2 constraintAnnotation) {
    }

    public boolean isValid(ParticipantV2 participant, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        List<ProductShareV2> products = participant.getProductShares();
        if (CollectionUtils.isEmpty(products)) {
            return true;
        }
        for (int pi = 0; pi < products.size(); ++pi) {
            ProductShareV2 productShare = products.get(pi);
            int productNumber = productShare.getProductNumber();
            if (productNumber == pi + 1) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV2.shareProducts.productNumber.invalidValue}").addPropertyNode("productNumber").addConstraintViolation();
        }
        return true;
    }
}

