/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedDateV2;

public class RelatedDateValidatorV2
implements ConstraintValidator<RelatedDateV2, InvoiceV2> {
    public void initialize(RelatedDateV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getRelatedInvoice() != null && invoice.getRelatedInvoice().getDate() == null) {
            if (invoice.getInvoiceType() != null) {
                if (invoice.getInvoiceType().equals(InvoiceType.ADDITIONAL_INVOICE)) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.additional.relatedInvoice.date.notNull}").addPropertyNode("relatedInvoice.date").addConstraintViolation();
                } else if (invoice.getInvoiceType().equals(InvoiceType.FIXED_INVOICE)) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.fixed.relatedInvoice.date.notNull}").addPropertyNode("relatedInvoice.date").addConstraintViolation();
                } else {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.fixed.relatedInvoice.date.notNull}").addPropertyNode("relatedInvoice.date").addConstraintViolation();
                }
            } else {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.notNull}").addPropertyNode("relatedInvoice.date").addConstraintViolation();
            }
            return false;
        }
        if (invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE || invoice.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE) {
            if (invoice.getRelatedInvoice() == null || invoice.getRelatedInvoice().getDate() == null) {
                return true;
            }
            Date parentDate = DateTimeUtils.startOfTheDay(invoice.getRelatedInvoice().getDate());
            Date childDate = DateTimeUtils.startOfTheDay(invoice.getDate());
            Calendar cal = Calendar.getInstance();
            cal.setTime(childDate);
            cal.add(1, -5);
            Date dateMinus5Years = cal.getTime();
            if (parentDate.compareTo(dateMinus5Years) < 0) {
                if (invoice.getInvoiceType() != null && invoice.getInvoiceType().equals(InvoiceType.ADDITIONAL_INVOICE)) {
                    context.buildConstraintViolationWithTemplate("{additionalInvoice.date.tooFar}").addConstraintViolation();
                } else {
                    context.buildConstraintViolationWithTemplate("{relatedInvoice.date.tooFar}").addConstraintViolation();
                }
                return false;
            }
            if (parentDate.compareTo(childDate) > 0) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.afterChild}").addPropertyNode("date").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

