/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.ReorganizedTinCheckV2;

public class ReorganizedTinCheckValidatorV2
implements ConstraintValidator<ReorganizedTinCheckV2, InvoiceV2> {
    public void initialize(ReorganizedTinCheckV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        int i;
        boolean isPaper;
        context.disableDefaultConstraintViolation();
        if (invoice.getInvoiceType() == null) {
            return true;
        }
        boolean valid = true;
        boolean bl = isPaper = invoice.getDatePaper() != null;
        if (invoice.getInvoiceType().equals(InvoiceType.ORDINARY_INVOICE) && !isPaper) {
            for (i = 0; i < invoice.getSellerReorganizedTinList().size(); ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)invoice.getSellerReorganizedTinList().get(i))) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.reorganizedTin.exists}").addPropertyNode("sellers[" + i + "].reorganizedTin").addConstraintViolation();
                valid = false;
            }
        }
        if (invoice.getInvoiceType().equals(InvoiceType.ORDINARY_INVOICE)) {
            for (i = 0; i < invoice.getNullableCustomerReorganizedTinList().size(); ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)invoice.getNullableCustomerReorganizedTinList().get(i))) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.reorganizedTin.exists}").addPropertyNode("customers[" + i + "].reorganizedTin").addConstraintViolation();
                valid = false;
            }
        }
        return valid;
    }
}

