/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2.field;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.field.CustomerTypesV2;

public class CustomerTypesValidatorV2
implements ConstraintValidator<CustomerTypesV2, List<CustomerTypeV2>> {
    private List<CustomerTypeV2> ALLOWED_WITH_RETAIL = Arrays.asList(CustomerTypeV2.COMMITTENT, CustomerTypeV2.BROKER, CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT, CustomerTypeV2.PUBLIC_OFFICE, CustomerTypeV2.NONRESIDENT);
    private List<CustomerTypeV2> ALLOWED_WITH_RETAIL_WITHOUT_NONRESIDENT = Arrays.asList(CustomerTypeV2.COMMITTENT, CustomerTypeV2.BROKER, CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT, CustomerTypeV2.PUBLIC_OFFICE);

    public void initialize(CustomerTypesV2 constraintAnnotation) {
    }

    public boolean isValid(List<CustomerTypeV2> statusList, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (statusList != null) {
            if (statusList.isEmpty()) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.emptyList}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(null)) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.containsNull}").addConstraintViolation();
                return false;
            }
            if (statusList.size() == 1) {
                return true;
            }
            if (statusList.size() != new HashSet<CustomerTypeV2>(statusList).size()) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.isDuplicated}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(CustomerTypeV2.RETAIL) && statusList.size() > 1 && (statusList.size() != 2 || !statusList.contains(CustomerTypeV2.INDIVIDUAL))) {
                if (statusList.contains(CustomerTypeV2.NONRESIDENT) && CollectionUtils.containsAny(this.ALLOWED_WITH_RETAIL_WITHOUT_NONRESIDENT, statusList)) {
                    if (statusList.size() != 3) {
                        context.buildConstraintViolationWithTemplate("{customerV2.statuses.retailExcludesOthers}").addConstraintViolation();
                        return false;
                    }
                } else if (CollectionUtils.containsAny(this.ALLOWED_WITH_RETAIL, statusList)) {
                    if (statusList.size() != 2) {
                        context.buildConstraintViolationWithTemplate("{customerV2.statuses.retailExcludesOthers}").addConstraintViolation();
                        return false;
                    }
                } else {
                    context.buildConstraintViolationWithTemplate("{customerV2.statuses.retailExcludesOthers}").addConstraintViolation();
                    return false;
                }
            }
            if (statusList.contains(CustomerTypeV2.COMMITTENT) && statusList.contains(CustomerTypeV2.BROKER)) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.commitentAndBrokerMutualExclusive}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT) && statusList.contains(CustomerTypeV2.SHARING_AGREEMENT_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.sharedMultipleMutualExclusive}").addConstraintViolation();
                return false;
            }
            if ((statusList.contains(CustomerTypeV2.PRINCIPAL) || statusList.contains(CustomerTypeV2.LESSEE) || statusList.contains(CustomerTypeV2.SHARING_AGREEMENT_PARTICIPANT)) && statusList.contains(CustomerTypeV2.RETAIL)) {
                context.buildConstraintViolationWithTemplate("{customerV2.statuses.retailCantBeWithPrincipal}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

