/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.EsfCollectionUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.utils.SntV1Helper;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntAlcoholSetV1;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntAlcoholSetCheckV1;

public class SntAlcoholSetValidatorV1
extends AbstractClassLevelValidator<SntAlcoholSetCheckV1, SntV1> {
    public void initialize(SntAlcoholSetCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        boolean isNotRequireOperationCode;
        boolean isTransfer;
        SntAlcoholSetV1 alcoholSet = snt.getAlcoholSet();
        if (alcoholSet == null) {
            return true;
        }
        boolean result = true;
        boolean isImport = snt.getSntImport() != null;
        boolean isExport = snt.getSntExport() != null;
        boolean bl = isTransfer = snt.getTransferType() != null;
        if (SntV1Helper.isAlcoholG45WithRetailCode(snt) && !SntType.RETURNED_SNT.equals(snt.getSntType())) {
            if (StringUtils.isEmpty((CharSequence)alcoholSet.getCustomerLicenseNumber())) {
                result = this.setupContextWithValidationError(context, "alcoholSet.customerLicenseNumber", this.generateNotNullFieldMessage("sntAlcoholSetV1.customerLicenseNumber"));
            }
            if (StringUtils.isEmpty((CharSequence)alcoholSet.getCustomerLicenseAddress())) {
                result = this.setupContextWithValidationError(context, "alcoholSet.customerLicenseAddress", this.generateNotNullFieldMessage("sntAlcoholSetV1.customerLicenseAddress"));
            }
        }
        boolean bl2 = isNotRequireOperationCode = isImport || isExport || isTransfer;
        if (!SntType.RETURNED_SNT.equals(snt.getSntType())) {
            boolean isSellerNonResident;
            if (alcoholSet.getEthanolProductSet() != null && StringUtils.isEmpty((CharSequence)alcoholSet.getEthanolProductSet().getOperationCode()) && !isNotRequireOperationCode) {
                result = this.setupContextWithValidationError(context, "alcoholSet.ethanolProductSet.operationCode", "{sntEthanolProductSetV1.operationCode.notNull}");
            }
            if (alcoholSet.getAlcoholBeerProductSet() != null) {
                if (StringUtils.isEmpty((CharSequence)alcoholSet.getAlcoholBeerProductSet().getOperationCode()) && !isNotRequireOperationCode) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.alcoholBeerProductSet.operationCode", "{sntAlcoholBeerProductSetV1.operationCode.notNull}");
                }
                if (snt.isCustomerRetail() && !"48".equals(alcoholSet.getAlcoholBeerProductSet().getOperationCode())) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.alcoholBeerProductSet.operationCode", "{sntV1.customer.retail.required.end_user.operationCode}");
                }
                if (!snt.isCustomerRetail() && "48".equals(alcoholSet.getAlcoholBeerProductSet().getOperationCode())) {
                    result = this.setupContextWithValidationError(context, "customer.statuses", "{sntV1.operationCode.end_user.required.customer.retail}");
                }
            }
            if (alcoholSet.getAlcoholExceptBeerProductSet() != null) {
                if (StringUtils.isEmpty((CharSequence)alcoholSet.getAlcoholExceptBeerProductSet().getOperationCode()) && !isNotRequireOperationCode) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.alcoholExceptBeerProductSet.operationCode", "{sntAlcoholExceptBeerProductSetV1.operationCode.notNull}");
                }
                if (snt.isCustomerRetail() && !"48".equals(alcoholSet.getAlcoholExceptBeerProductSet().getOperationCode())) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.alcoholExceptBeerProductSet.operationCode", "{sntV1.customer.retail.required.end_user.operationCode}");
                }
                if (!snt.isCustomerRetail() && "48".equals(alcoholSet.getAlcoholExceptBeerProductSet().getOperationCode())) {
                    result = this.setupContextWithValidationError(context, "customer.statuses", "{sntV1.operationCode.end_user.required.customer.retail}");
                }
            }
            if (!(isSellerNonResident = BooleanUtils.isTrue((Boolean)LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSeller().getNonResident())))) {
                boolean licenseNotRequiredForSystemStore;
                Set<SntProductTypeV1> sntProductTypes = snt.getProductsByType().keySet();
                boolean bl3 = licenseNotRequiredForSystemStore = snt.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ && CollectionUtils.containsAny(sntProductTypes, Arrays.asList(SntProductTypeV1.ETHANOL, SntProductTypeV1.WINE_MATERIAL, SntProductTypeV1.BEER, SntProductTypeV1.ALCOHOL_EXCEPT_BEER));
                if (!licenseNotRequiredForSystemStore) {
                    if (StringUtils.isEmpty((CharSequence)alcoholSet.getSellerLicenseNumber())) {
                        result = this.setupContextWithValidationError(context, "alcoholSet.sellerLicenseNumber", this.generateNotNullFieldMessage("sntAlcoholSetV1.sellerLicenseNumber"));
                    }
                    if (StringUtils.isEmpty((CharSequence)alcoholSet.getSellerLicenseAddress())) {
                        result = this.setupContextWithValidationError(context, "alcoholSet.sellerLicenseAddress", this.generateNotNullFieldMessage("sntAlcoholSetV1.sellerLicenseAddress"));
                    }
                }
            }
        }
        if (SntType.RETURNED_SNT.equals(snt.getSntType())) {
            Boolean sellerNonResident = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSeller().getNonResident());
            List customerStatuses = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getCustomer().getStatuses());
            String ethanolOpCode = LambdaUtils.nullSafeApplyFunction(alcoholSet, as -> as.getEthanolProductSet().getOperationCode());
            String alcoholBeerOpCode = LambdaUtils.nullSafeApplyFunction(alcoholSet, as -> as.getAlcoholBeerProductSet().getOperationCode());
            String alcoholExceptBeerOpCode = LambdaUtils.nullSafeApplyFunction(alcoholSet, as -> as.getAlcoholExceptBeerProductSet().getOperationCode());
            if (BooleanUtils.isFalse((Boolean)sellerNonResident) && !EsfCollectionUtils.nullSafeContainsAll(customerStatuses, Arrays.asList(SntCustomerTypeV1.RETAIL, SntCustomerTypeV1.INDIVIDUAL)) && "15".equals(ethanolOpCode) && "15".equals(alcoholBeerOpCode) && "15".equals(alcoholExceptBeerOpCode) && StringUtils.isEmpty((CharSequence)alcoholSet.getSellerLicenseNumber())) {
                result = this.setupContextWithValidationError(context, "alcoholSet.sellerLicenseNumber", "{sntAlcoholSetV1.sellerLicenseNumber.notNull}");
            }
        }
        if (!this.validateForSmallRetailOutlet(snt, context)) {
            result = false;
        }
        return result;
    }

    private boolean validateForSmallRetailOutlet(SntV1 snt, ConstraintValidatorContext context) {
        boolean result = true;
        if ((snt.getSntType() == SntType.PRIMARY_SNT || snt.getSntType() == SntType.FIXED_SNT) && snt.getCustomer() != null && snt.getCustomer().containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET)) {
            String g4OperationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getAlcoholSet().getAlcoholBeerProductSet().getOperationCode());
            String g5OperationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getAlcoholSet().getAlcoholExceptBeerProductSet().getOperationCode());
            String g2OperationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getAlcoholSet().getEthanolProductSet().getOperationCode());
            if (StringUtils.isNotEmpty((CharSequence)g4OperationCode) && !"10".equals(g4OperationCode) && !"7".equals(g4OperationCode)) {
                result = this.setupContextWithValidationError(context, "alcoholSet.alcoholBeerProductSet.operationCode", "{sntAlcoholBeerProductSetV1.operationCode.smallRetailOutlet.required.7.10}");
            }
            if (StringUtils.isNotEmpty((CharSequence)g5OperationCode) && !"10".equals(g5OperationCode) && !"7".equals(g5OperationCode)) {
                result = this.setupContextWithValidationError(context, "alcoholSet.alcoholExceptBeerProductSet.operationCode", "{sntAlcoholExceptBeerProductSetV1.operationCode.smallRetailOutlet.required.7.10}");
            }
            if (StringUtils.isNotEmpty((CharSequence)g2OperationCode)) {
                result = this.setupContextWithValidationError(context, "alcoholSet.ethanolProductSet.operationCode", "{sntEthanolProductSetV1.operationCode.smallRetailOutlet.mustBeNull}");
            }
            if (StringUtils.isNotEmpty((CharSequence)g4OperationCode) && StringUtils.isNotEmpty((CharSequence)g5OperationCode)) {
                SntAlcoholSetV1 alcoholSet = snt.getAlcoholSet();
                if (StringUtils.isEmpty((CharSequence)alcoholSet.getCustomerLicenseNumber())) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.customerLicenseNumber", this.generateNotNullFieldMessage("sntAlcoholSetV1.customerLicenseNumber"));
                }
                if (StringUtils.isEmpty((CharSequence)alcoholSet.getCustomerLicenseAddress())) {
                    result = this.setupContextWithValidationError(context, "alcoholSet.customerLicenseAddress", this.generateNotNullFieldMessage("sntAlcoholSetV1.customerLicenseAddress"));
                }
            }
        }
        return result;
    }
}

