/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntAlcoholBeerProductV1;
import ru.uss.esf.validation.snt.version.v1.SntBearProductCheckV1;

public class SntBearProductValidatorV1
extends AbstractClassLevelValidator<SntBearProductCheckV1, SntAlcoholBeerProductV1> {
    public void initialize(SntBearProductCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntAlcoholBeerProductV1 product, ConstraintValidatorContext context) {
        boolean isValid = true;
        BigDecimal containerCount = product.getContainerCount();
        BigDecimal quantityInLiters = product.getQuantityInLiters();
        String measureUnitCode = product.getMeasureUnitCode();
        if ("112".equals(measureUnitCode)) {
            if (containerCount != null && quantityInLiters != null && containerCount.compareTo(quantityInLiters) != 0) {
                isValid = this.setupContextWithValidationError(context, "containerCount", "{sntAlcoholBeerProductV1.containerCount.notEquals.quantityInLiters}");
            }
        } else {
            int scale;
            if (product.getContainerCount() != null && (scale = product.getContainerCount().scale()) > 0) {
                isValid = this.setupContextWithValidationError(context, "containerCount", "{sntAlcoholBeerProductV1.containerCount.wrongFormat}");
            }
            BigDecimal multiplyResult = new BigDecimal(1);
            multiplyResult = multiplyResult.multiply(product.getContainerCapacity() == null ? BigDecimal.ZERO : product.getContainerCapacity());
            multiplyResult = multiplyResult.multiply(product.getTotalContainerCount() == null ? BigDecimal.ZERO : product.getTotalContainerCount());
            if ((multiplyResult = multiplyResult.setScale(6, RoundingMode.HALF_UP)).compareTo(product.getQuantityInLiters() == null ? BigDecimal.ZERO : product.getQuantityInLiters()) != 0) {
                isValid = this.setupContextWithValidationError(context, "quantityInLiters", "{sntAlcoholBeerProductV1.quantityInLiters.incorrect}");
            }
        }
        return isValid;
    }
}

