/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntConsigneeCountryCodeCheckV1;

public class SntConsigneeCountryCodeValidatorV1
extends AbstractClassLevelValidator<SntConsigneeCountryCodeCheckV1, SntV1> {
    private static final List<SntExportTypeV1> needNoKzExportTypes = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.AIRCRAFT_REFUELING);

    public void initialize(SntConsigneeCountryCodeCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (!(sntV1.getSntExport() != null && needNoKzExportTypes.contains(sntV1.getSntExport().getExportType()) || sntV1.getTransferType() == null || sntV1.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_EAEU || sntV1.getTransferType() == SntTransferTypeV1.OTHER)) {
            if (sntV1.getConsignor() != null && !"KZ".equals(sntV1.getConsignor().getCountryCode())) {
                return this.setupContextWithValidationError(context, "consignor.countryCode", "{sntConsignorV1.countryCode.onlyKZ}");
            }
            if (sntV1.getConsignee() != null && !"KZ".equals(sntV1.getConsignee().getCountryCode())) {
                return this.setupContextWithValidationError(context, "consignee.countryCode", "{sntConsigneeV1.countryCode.onlyKZ}");
            }
        }
        if (sntV1.getSntExport() == null && sntV1.getTransferType() == null && sntV1.getConsignee() != null && !"KZ".equals(sntV1.getConsignee().getCountryCode())) {
            return this.setupContextWithValidationError(context, "consignee.countryCode", "{sntConsigneeV1.countryCode.onlyKZ}");
        }
        return true;
    }
}

