/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.dictionary.Country;
import ru.uss.esf.model.snt.version.v1.SntConsignorV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntConsignorTinCheckV1;

public class SntConsignorTinValidatorV1
extends AbstractClassLevelValidator<SntConsignorTinCheckV1, SntV1> {
    public void initialize(SntConsignorTinCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (sntV1.getSntImport() == null && sntV1.getSntExport() == null && sntV1.getTransferType() == null) {
            return true;
        }
        SntConsignorV1 consignor = sntV1.getConsignor();
        if (consignor == null || BooleanUtils.isNotTrue((Boolean)consignor.getNonResident())) {
            return true;
        }
        boolean isValid = true;
        List<String> eaecCountryCodes = Country.EAEC_COUNTRY_CODES;
        if (eaecCountryCodes.contains(consignor.getCountryCode())) {
            if (StringUtils.isBlank((CharSequence)consignor.getTin())) {
                isValid = this.setupContextWithValidationError(context, "consignor.tin", "{sntConsignorV1.tin.nonresident}");
            } else if ("AM".equals(consignor.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignor.getTin()) || consignor.getTin().length() != 8)) {
                isValid = this.setupContextWithValidationError(context, "consignor.tin", "{sntConsignorV1.tin.length_am}");
            } else if ("BY".equals(consignor.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignor.getTin()) || consignor.getTin().length() != 9)) {
                isValid = this.setupContextWithValidationError(context, "consignor.tin", "{sntConsignorV1.tin.length_by}");
            } else if ("RU".equals(consignor.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignor.getTin()) || consignor.getTin().length() != 10 && consignor.getTin().length() != 12)) {
                isValid = this.setupContextWithValidationError(context, "consignor.tin", "{sntConsignorV1.tin.length_ru}");
            } else if ("KG".equals(consignor.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignor.getTin()) || consignor.getTin().length() != 14)) {
                isValid = this.setupContextWithValidationError(context, "consignor.tin", "{sntConsignorV1.tin.length_kg}");
            }
        }
        return isValid;
    }
}

