/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntContractV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntContractCheckV1;

public class SntContractValidatorV1
extends AbstractClassLevelValidator<SntContractCheckV1, SntV1> {
    public static final Pattern ACCOUNT_NUMBER_PATTERN = Pattern.compile("([12])/[0-9]{3}/[0-9]{4}/[0-9]{1,20}");

    public void initialize(SntContractCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        boolean hasError = false;
        SntContractV1 sntContractV1 = sntV1.getContract();
        if (sntContractV1 != null) {
            if (BooleanUtils.isTrue((Boolean)sntContractV1.getContract())) {
                if (StringUtils.isEmpty((CharSequence)sntContractV1.getNumber())) {
                    this.setupContextWithValidationError(context, "contract.number", "{sntContractV1.dateNum.required}");
                    hasError = true;
                }
                if (sntContractV1.getDate() == null) {
                    this.setupContextWithValidationError(context, "contract.date", "{sntContractV1.dateNum.required}");
                    hasError = true;
                }
            } else {
                if (StringUtils.isNotEmpty((CharSequence)sntContractV1.getNumber())) {
                    this.setupContextWithValidationError(context, "contract.number", "{sntContractV1.dateNum.notRequired}");
                    hasError = true;
                }
                if (sntContractV1.getDate() != null) {
                    this.setupContextWithValidationError(context, "contract.date", "{sntContractV1.dateNum.notRequired}");
                    hasError = true;
                }
            }
            if (sntV1.getSntType() != SntType.RETURNED_SNT && StringUtils.isNotEmpty((CharSequence)sntContractV1.getAccountNumber())) {
                if (!BooleanUtils.isTrue((Boolean)sntContractV1.getContract())) {
                    this.setupContextWithValidationError(context, "contract.accountNumber", "{sntContractV1.accountNumber.mustBeNull}");
                    hasError = true;
                }
                if (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType()) != SntExportTypeV1.EXPORT && (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType()) != SntExportTypeV1.EXPORT_FROM_SEZ || "KZ".equals(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getCountryCode()))) && LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType()) != SntImportTypeV1.IMPORT && (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType()) != SntImportTypeV1.IMPORT_IN_SEZ || "KZ".equals(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getCountryCode())))) {
                    this.setupContextWithValidationError(context, "contract.accountNumber", "{sntContractV1.accountNumber.mustBeNull}");
                    hasError = true;
                }
                if (sntContractV1.getAccountNumber().charAt(0) == '1') {
                    if (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType()) != SntExportTypeV1.EXPORT && (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType()) != SntExportTypeV1.EXPORT_FROM_SEZ || "KZ".equals(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getCountryCode())))) {
                        this.setupContextWithValidationError(context, "contract.accountNumber", "{sntContractV1.accountNumber.wrongFirstFacet}");
                        hasError = true;
                    }
                } else if (sntContractV1.getAccountNumber().charAt(0) == '2' && LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType()) != SntImportTypeV1.IMPORT && (LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType()) != SntImportTypeV1.IMPORT_IN_SEZ || "KZ".equals(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getCountryCode())))) {
                    this.setupContextWithValidationError(context, "contract.accountNumber", "{sntContractV1.accountNumber.wrongFirstFacet}");
                    hasError = true;
                }
                if (!ACCOUNT_NUMBER_PATTERN.matcher(sntContractV1.getAccountNumber()).matches()) {
                    this.setupContextWithValidationError(context, "contract.accountNumber", "{sntContractV1.accountNumber.wrongFormat}");
                    hasError = true;
                }
            }
        }
        return !hasError;
    }

    public static void main(String[] args) {
        System.out.println("true :" + ACCOUNT_NUMBER_PATTERN.matcher("1/123/1234/1").matches());
        System.out.println("true :" + ACCOUNT_NUMBER_PATTERN.matcher("2/123/1234/1").matches());
        System.out.println("true :" + ACCOUNT_NUMBER_PATTERN.matcher("2/123/1234/12345678901234567890").matches());
        System.out.println("false :" + ACCOUNT_NUMBER_PATTERN.matcher("2/123/1234/123456789012345678901").matches());
        System.out.println("false :" + ACCOUNT_NUMBER_PATTERN.matcher("3/123/1234/1").matches());
        System.out.println("false :" + ACCOUNT_NUMBER_PATTERN.matcher("1/1234/1234/1").matches());
        System.out.println("false :" + ACCOUNT_NUMBER_PATTERN.matcher("1/123/12345/1").matches());
    }
}

