/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntCustomerV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.snt.version.v1.SntCustomerNonResidentCheckV1;

public class SntCustomerNonResidentValidatorV1
extends AbstractClassLevelValidator<SntCustomerNonResidentCheckV1, SntV1> {
    public void initialize(SntCustomerNonResidentCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        String ethanolOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getEthanolProductSet().getOperationCode());
        String alcoholBeerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholBeerProductSet().getOperationCode());
        String alcoholExceptBeerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholExceptBeerProductSet().getOperationCode());
        String oilOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOilSet().getOperationCode());
        String biofuelOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getBiofuelSet().getOperationCode());
        boolean isNonResidentRequired = false;
        if ((SntType.PRIMARY_SNT.equals(sntV1.getSntType()) || SntType.FIXED_SNT.equals(sntV1.getSntType())) && ("15".equals(ethanolOpCode) || "15".equals(alcoholBeerOpCode) || "15".equals(alcoholExceptBeerOpCode) || "26".equals(oilOpCode) || "34".equals(biofuelOpCode))) {
            isNonResidentRequired = true;
        }
        SntCustomerV1 sntCustomerV1 = sntV1.getCustomer();
        if (isNonResidentRequired && BooleanUtils.isNotTrue((Boolean)sntCustomerV1.getNonResident())) {
            return this.setupContextWithValidationError(context, "customer.nonResident", this.generateNotNullFieldMessage("sntCustomerV1.nonResident"));
        }
        if (sntV1.getSntImport() != null && BooleanUtils.isTrue((Boolean)sntCustomerV1.getNonResident()) && StringUtils.isNotEmpty((CharSequence)sntCustomerV1.getTin()) && (TinValidator.isTin(sntCustomerV1.getTin()) || TinValidator.isIin(sntCustomerV1.getTin()))) {
            return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tinForNonResident.notValid}");
        }
        return true;
    }
}

