/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.consts.EsfConst;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntDeclarationRequirementV1;

public class SntDeclarationRequirementValidatorV1
extends AbstractClassLevelValidator<SntDeclarationRequirementV1, SntV1> {
    private static final List<SntImportTypeV1> notRequireFieldImportTypes = Arrays.asList(SntImportTypeV1.IMPORT, SntImportTypeV1.IMPORT_FOR_PROCESSING, SntImportTypeV1.TEMPORARY_IMPORT, SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT);
    private static final List<String> requiredTruOriginCodes = Arrays.asList("1", "2");

    public void initialize(SntDeclarationRequirementV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (sntV1 == null) {
            return true;
        }
        boolean result = true;
        SntImportTypeV1 sntImportTypeV1 = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType());
        SntExportTypeV1 sntExportTypeV1 = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType());
        boolean isImport = sntImportTypeV1 != null && notRequireFieldImportTypes.contains(sntImportTypeV1);
        boolean isTransferTypeOnePersonEaeuSellerNonRedisent = BooleanUtils.isTrue((Boolean)LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident())) && sntV1.getTransferType() != null && SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(sntV1.getTransferType());
        String sellerRegisterCountryCode = sntV1.getSeller() == null ? null : sntV1.getSeller().getCountryCode();
        String sellerCountryCode = sntV1.getSeller() == null ? null : sntV1.getSeller().getCountryCode();
        String customerCountryCode = sntV1.getCustomer() == null ? null : sntV1.getCustomer().getCountryCode();
        boolean isSellerKzCounty = "KZ".equalsIgnoreCase(sellerRegisterCountryCode);
        boolean isCustomerCountyEaecMember = EsfConst.EAEC_COUNTRY_CODES_WITHOUT_KZ.contains(customerCountryCode);
        boolean isSellerCountyEaecMember = EsfConst.EAEC_COUNTRY_CODES_WITHOUT_KZ.contains(sellerCountryCode);
        boolean isCustomerKzCounty = "KZ".equalsIgnoreCase(customerCountryCode);
        boolean isOtherTransferFromNotEaeu = SntTransferTypeV1.OTHER.equals(sntV1.getTransferType()) && !isSellerKzCounty;
        boolean isImportSezForNonResident = sntImportTypeV1 == SntImportTypeV1.IMPORT_IN_SEZ && BooleanUtils.isTrue((Boolean)LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident()));
        boolean isReturnedAsImport = isImport && SntType.RETURNED_SNT.equals(sntV1.getSntType());
        boolean isImportOfTemporalExport = SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT.equals(sntImportTypeV1);
        boolean isProductDeclarationRequired = isImportOfTemporalExport || isReturnedAsImport || !isImport && !isImportSezForNonResident && !isTransferTypeOnePersonEaeuSellerNonRedisent && !isOtherTransferFromNotEaeu;
        boolean isSntNumberDisabledForEaecOrigin1 = sntV1.getSntType() != SntType.RETURNED_SNT && sntExportTypeV1 == SntExportTypeV1.EXPORT && isCustomerCountyEaecMember;
        boolean isSntNumberDisabledForNotEaecOrigin12 = sntV1.getSntType() != SntType.RETURNED_SNT && sntExportTypeV1 == SntExportTypeV1.EXPORT && !isCustomerCountyEaecMember && !isCustomerKzCounty;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = sntV1.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                for (int i = 0; i < sntAbstractProducts.size(); ++i) {
                    SntAbstractProduct product = sntAbstractProducts.get(i);
                    boolean isDeclarationNumberForSntNotRequired = (isImport || isTransferTypeOnePersonEaeuSellerNonRedisent) && StringUtils.isNotEmpty((CharSequence)product.getDeclarationNumberForSnt());
                    if ((isDeclarationNumberForSntNotRequired &= !isImportOfTemporalExport) && !isReturnedAsImport) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].declarationNumberForSnt", i), "{sntBaseProductV1.declarationNumberForSnt.mustBuNull}");
                        result = false;
                    }
                    boolean isTruOriginRequireDeclaration = requiredTruOriginCodes.contains(product.getTruOriginCode());
                    if (isProductDeclarationRequired && isTruOriginRequireDeclaration && StringUtils.isEmpty((CharSequence)product.getDeclarationNumberForSnt())) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].declarationNumberForSnt", i), "{sntBaseProductV1.declarationNumberForSnt.notNull}");
                        result = false;
                    }
                    boolean isProductNumberInDeclaration = (isImport || isTransferTypeOnePersonEaeuSellerNonRedisent) && StringUtils.isNotEmpty((CharSequence)product.getDeclarationNumberForSnt());
                    if ((isProductNumberInDeclaration &= !isImportOfTemporalExport) && !isReturnedAsImport) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productNumberInDeclaration", i), "{sntBaseProductV1.productNumberInDeclaration.mustBuNull}");
                        result = false;
                    }
                    if (isProductDeclarationRequired && isTruOriginRequireDeclaration && StringUtils.isEmpty((CharSequence)product.getProductNumberInDeclaration())) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productNumberInDeclaration", i), "{sntBaseProductV1.productNumberInDeclaration.notNull}");
                        result = false;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)product.getDeclarationNumberForSnt()) || !RegistrationNumberUtils.isSnt(product.getDeclarationNumberForSnt()) || !("1".equals(product.getTruOriginCode()) && isSntNumberDisabledForEaecOrigin1 || "1".equals(product.getTruOriginCode()) && isSntNumberDisabledForNotEaecOrigin12) && (!"2".equals(product.getTruOriginCode()) || !isSntNumberDisabledForNotEaecOrigin12)) continue;
                    if ("1".equals(product.getTruOriginCode()) && isSntNumberDisabledForEaecOrigin1) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].declarationNumberForSnt", i), "{sntBaseProductV1.declarationNumberForSnt.snt.eaec.wrongFormat}");
                        result = false;
                        continue;
                    }
                    this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].declarationNumberForSnt", i), "{sntBaseProductV1.declarationNumberForSnt.snt.notEaec.wrongFormat}");
                    result = false;
                }
            }
        }
        return result;
    }
}

