/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntExportCheckV1;

public class SntExportValidatorV1
extends AbstractClassLevelValidator<SntExportCheckV1, SntV1> {
    public void initialize(SntExportCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (sntV1.getSntExport() != null) {
            if (sntV1.getSntImport() != null || sntV1.getTransferType() != null) {
                return this.setupContextWithValidationError(context, "sntExport", "{sntV1.exportType.mustBeNull}");
            }
            if (SntExportTypeV1.AIRCRAFT_REFUELING.equals(sntV1.getSntExport().getExportType())) {
                return this.setupContextWithValidationError(context, "sntExport", "{sntV1.exportType.AIRCRAFT_REFUELING.blocked}");
            }
            if (SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT.equals(sntV1.getSntExport().getExportType()) && sntV1.getSntType() != SntType.RETURNED_SNT) {
                return this.setupContextWithValidationError(context, "sntExport", "{sntV1.exportType.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT.requiresReturnedSnt}");
            }
        }
        return true;
    }
}

