/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntAlcoholBeerProductV1;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntBiofuelProductV1;
import ru.uss.esf.model.snt.version.v1.SntExportControlProductV1;
import ru.uss.esf.model.snt.version.v1.SntOilProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.model.snt.version.v1.SntWineMaterialProductV1;
import ru.uss.esf.validation.snt.version.v1.SntProductExciseAmountCheckV1;

public class SntProductExciseAmountValidatorV1
extends AbstractClassLevelValidator<SntProductExciseAmountCheckV1, SntV1> {
    List<SntProductTypeV1> lightFlkProductTypes = Collections.unmodifiableList(Arrays.asList(SntProductTypeV1.PRODUCT, SntProductTypeV1.WINE_MATERIAL, SntProductTypeV1.BEER, SntProductTypeV1.OIL, SntProductTypeV1.BIOFUEL, SntProductTypeV1.EXPORT_CONTROL_PRODUCT));

    public void initialize(SntProductExciseAmountCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = snt.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntBaseProducts;
                if (!this.lightFlkProductTypes.contains((Object)sntProductType) || (sntBaseProducts = productsByType.get((Object)sntProductType)) == null) continue;
                for (int i = 0; i < sntBaseProducts.size(); ++i) {
                    SntBaseProductV1 product = sntBaseProducts.get(i);
                    BigDecimal computedExciseAmount = null;
                    switch (sntProductType) {
                        case PRODUCT: {
                            SntBaseProductV1 definedProduct = (SntProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntProductV1)definedProduct).getQuantity() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntProductV1)definedProduct).getQuantity()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                        case ETHANOL: {
                            break;
                        }
                        case WINE_MATERIAL: {
                            SntBaseProductV1 definedProduct = (SntWineMaterialProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntWineMaterialProductV1)definedProduct).getQuantityInLiters() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntWineMaterialProductV1)definedProduct).getQuantityInLiters()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                        case BEER: {
                            SntBaseProductV1 definedProduct = (SntAlcoholBeerProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntAlcoholBeerProductV1)definedProduct).getQuantityInLiters() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntAlcoholBeerProductV1)definedProduct).getQuantityInLiters()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                        case ALCOHOL_EXCEPT_BEER: {
                            break;
                        }
                        case OIL: {
                            SntBaseProductV1 definedProduct = (SntOilProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntOilProductV1)definedProduct).getQuantity() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntOilProductV1)definedProduct).getQuantity()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                        case BIOFUEL: {
                            SntBaseProductV1 definedProduct = (SntBiofuelProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntBiofuelProductV1)definedProduct).getQuantity() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntBiofuelProductV1)definedProduct).getQuantity()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                        case TOBACCO: {
                            break;
                        }
                        case OTHER_PRODUCT_WITH_DIGITAL_MARK: {
                            break;
                        }
                        case EXPORT_CONTROL_PRODUCT: {
                            SntBaseProductV1 definedProduct = (SntExportControlProductV1)product;
                            if (definedProduct.getExciseRate() == null || ((SntExportControlProductV1)definedProduct).getQuantity() == null) break;
                            computedExciseAmount = definedProduct.getExciseRate().multiply(((SntExportControlProductV1)definedProduct).getQuantity()).setScale(2, RoundingMode.HALF_UP);
                            break;
                        }
                    }
                    if (computedExciseAmount == null && product.getExciseAmount() == null || computedExciseAmount == null || product.getExciseAmount() != null && computedExciseAmount.compareTo(product.getExciseAmount()) == 0) continue;
                    context.buildConstraintViolationWithTemplate("{sntBaseProductV1.exciseAmount.incorrect}").addPropertyNode(String.format(sntProductType.getProductsPath() + "[%d].exciseAmount", i)).addConstraintViolation();
                    result = false;
                }
            }
        }
        return result;
    }
}

