/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductMeasureUnitCheckV1;

public class SntProductMeasureUnitValidatorV1
extends AbstractClassLevelValidator<SntProductMeasureUnitCheckV1, SntV1> {
    private static final List<SntImportTypeV1> notRequireProductIdImportTypes = Arrays.asList(SntImportTypeV1.IMPORT, SntImportTypeV1.IMPORT_FOR_PROCESSING, SntImportTypeV1.TEMPORARY_IMPORT, SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT);
    private static final List<SntImportTypeV1> importTypesWithoutSez = Collections.unmodifiableList(SntImportTypeV1.importTypesWithoutSez());
    private static final List<String> oilProductSellerTypesWithTon = Collections.unmodifiableList(Arrays.asList("1", "2", "4", "5"));
    private static final List<String> biofuelProductSellerTypesWithTon = Collections.unmodifiableList(Arrays.asList("1", "4"));

    public void initialize(SntProductMeasureUnitCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (sntV1 == null) {
            return true;
        }
        boolean result = true;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = sntV1.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                SntImportTypeV1 sntImportTypeV1;
                if (!sntProductType.equals((Object)SntProductTypeV1.OIL) && !sntProductType.equals((Object)SntProductTypeV1.BIOFUEL)) continue;
                String requiredMeasureUnitCode = null;
                if (sntProductType.equals((Object)SntProductTypeV1.OIL) && oilProductSellerTypesWithTon.contains(sntV1.getOilSet().getProductSellerType())) {
                    requiredMeasureUnitCode = "168";
                }
                if (sntProductType.equals((Object)SntProductTypeV1.BIOFUEL) && biofuelProductSellerTypesWithTon.contains(sntV1.getBiofuelSet().getProductSellerType())) {
                    requiredMeasureUnitCode = "168";
                }
                if (importTypesWithoutSez.contains(sntImportTypeV1 = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getSntImport().getImportType())) || SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(sntV1.getTransferType()) || SntTransferTypeV1.OTHER.equals(sntV1.getTransferType())) {
                    requiredMeasureUnitCode = "168";
                }
                if (requiredMeasureUnitCode == null) continue;
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                for (int i = 0; i < sntAbstractProducts.size(); ++i) {
                    SntBaseProductV1 product = sntAbstractProducts.get(i);
                    if (requiredMeasureUnitCode.equals(product.getMeasureUnitCode())) continue;
                    this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].measureUnitCode", i), "{oilOrBiofuelProductV1.measureUnitCode.invalid}");
                    result = false;
                }
            }
        }
        return result;
    }
}

