/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductOriginCodeCheckV1;

public class SntProductOriginCodeValidatorV1
extends AbstractClassLevelValidator<SntProductOriginCodeCheckV1, SntV1> {
    public void initialize(SntProductOriginCodeCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (sntV1 == null) {
            return true;
        }
        if (sntV1.getSntType() == SntType.RETURNED_SNT || SntImportTypeV1.IMPORT != LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType())) {
            return true;
        }
        boolean result = true;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = sntV1.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                int productsCount = sntAbstractProducts.size();
                for (int i = 0; i < productsCount; ++i) {
                    String originCode = ((SntAbstractProduct)sntAbstractProducts.get(i)).getTruOriginCode();
                    if ("1".equals(originCode) || "2".equals(originCode)) continue;
                    this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].truOriginCode", i), "{sntBaseProductV1.truOriginCode.notAllowedValue}");
                    result = false;
                }
            }
        }
        return result;
    }
}

