/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductPinCodeCheckV1;

public class SntProductPinCodeValidatorV1
extends AbstractClassLevelValidator<SntProductPinCodeCheckV1, SntV1> {
    public void initialize(SntProductPinCodeCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 snt, ConstraintValidatorContext constraintValidatorContext) {
        boolean licenseNotRequiredForSystemStore;
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (snt == null) {
            return true;
        }
        boolean result = true;
        Set<SntProductTypeV1> sntProductTypes = snt.getProductsByType().keySet();
        boolean bl = licenseNotRequiredForSystemStore = snt.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ && CollectionUtils.containsAny(sntProductTypes, Arrays.asList(SntProductTypeV1.ETHANOL, SntProductTypeV1.WINE_MATERIAL, SntProductTypeV1.ALCOHOL_EXCEPT_BEER));
        if (!licenseNotRequiredForSystemStore) {
            Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = snt.getProductsByType();
            List<SntProductTypeV1> alcoholProductTypes = Arrays.asList(SntProductTypeV1.ETHANOL, SntProductTypeV1.WINE_MATERIAL, SntProductTypeV1.ALCOHOL_EXCEPT_BEER);
            for (SntProductTypeV1 alcoholProductType : alcoholProductTypes) {
                List<? extends SntBaseProductV1> sntProducts = productsByType.get((Object)alcoholProductType);
                if (!CollectionUtils.isNotEmpty(sntProducts)) continue;
                for (int i = 0; i < sntProducts.size(); ++i) {
                    SntBaseProductV1 product = sntProducts.get(i);
                    if (!StringUtils.isEmpty((CharSequence)product.getPinCode())) continue;
                    this.addConstraintViolation(constraintValidatorContext, String.format(alcoholProductType.getProductsPath() + "[%d].pinCode", i), "{sntBaseProductV1.pinCode.notNull}");
                    result = false;
                }
            }
        }
        return result;
    }
}

