/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntSellerV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerTinCheckV1;

public class SntSellerTinValidatorV1
extends AbstractClassLevelValidator<SntSellerTinCheckV1, SntV1> {
    public static final Pattern TIN_PATTERN = Pattern.compile("[0-9]*");

    public void initialize(SntSellerTinCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        SntSellerV1 seller = sntV1.getSeller();
        if (seller == null) {
            return true;
        }
        boolean isTinRequired = true;
        if (SntType.PRIMARY_SNT.equals(sntV1.getSntType())) {
            if (seller.isRetail()) {
                if (StringUtils.isNotEmpty((CharSequence)seller.getTin())) {
                    return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tin.mustBeNull}");
                }
            } else if (sntV1.getSntImport() != null && BooleanUtils.isNotTrue((Boolean)seller.getNonResident()) && StringUtils.isBlank((CharSequence)seller.getTin())) {
                return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tin.isMissing}");
            }
            if (StringUtils.isNotEmpty((CharSequence)seller.getTin()) && !TIN_PATTERN.matcher(seller.getTin()).matches()) {
                return this.setupContextWithValidationError(context, "seller.tin", "{snt.participant.tin.digitalFormatRequired}");
            }
        } else if (SntType.RETURNED_SNT.equals(sntV1.getSntType())) {
            isTinRequired = false;
        }
        int tinLength = StringUtils.length((CharSequence)seller.getTin());
        if (BooleanUtils.isTrue((Boolean)seller.getNonResident())) {
            if (seller.getTin() != null && seller.getTin().matches(".*[\\s\\t\\n\\r]+.*")) {
                return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tin.wrongFormat}");
            }
            if (tinLength > 50) {
                return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tin.longMask}");
            }
        } else if (isTinRequired ? tinLength != 12 : tinLength != 0 && tinLength < 12) {
            return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tin.shortMask}");
        }
        return true;
    }
}

