/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.uss.core.utils.EsfModelCollectionUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntShippingInfoV1;
import ru.uss.esf.model.snt.version.v1.SntTransportTypeV1;
import ru.uss.esf.validation.snt.version.v1.SntTransportTypesCheckV1;

public class SntTransportTypesValidatorV1
extends AbstractClassLevelValidator<SntTransportTypesCheckV1, SntShippingInfoV1> {
    public void initialize(SntTransportTypesCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntShippingInfoV1 shippingInfoV1, ConstraintValidatorContext context) {
        HashSet sntTransportTypeSet;
        if (shippingInfoV1 == null) {
            return true;
        }
        boolean carStateNumberEmpty = StringUtils.isEmpty((CharSequence)shippingInfoV1.getCarStateNumber());
        boolean carriageNumberEmpty = StringUtils.isEmpty((CharSequence)shippingInfoV1.getCarriageNumber());
        boolean boardNumberEmpty = StringUtils.isEmpty((CharSequence)shippingInfoV1.getBoardNumber());
        boolean shipNumberEmpty = StringUtils.isEmpty((CharSequence)shippingInfoV1.getShipNumber());
        List transportTypes = LambdaUtils.nullSafeApplyFunction(shippingInfoV1, SntShippingInfoV1::getTransportTypes, Collections.emptyList());
        boolean isValid = true;
        if (EsfModelCollectionUtils.nullSafeContainsAny(transportTypes, SntTransportTypeV1.AUTOMOBILE)) {
            if (carStateNumberEmpty) {
                isValid = this.setupContextWithValidationError(context, "carStateNumber", "{sntShippingInfoV1.carStateNumber.notNull}");
            }
        } else if (!carStateNumberEmpty) {
            isValid = this.setupContextWithValidationError(context, "carModel", "{sntShippingInfoV1.transportTypes.AUTOMOBILE.notNull}");
        }
        if (!carriageNumberEmpty && !EsfModelCollectionUtils.nullSafeContainsAny(transportTypes, SntTransportTypeV1.RAILWAY)) {
            isValid = this.setupContextWithValidationError(context, "transportTypes", "{sntShippingInfoV1.transportTypes.RAILWAY.notNull}");
        }
        if (!boardNumberEmpty && !EsfModelCollectionUtils.nullSafeContainsAny(transportTypes, SntTransportTypeV1.AIR)) {
            isValid = this.setupContextWithValidationError(context, "transportTypes", "{sntShippingInfoV1.transportTypes.AIR.notNull}");
        }
        if (!shipNumberEmpty && !EsfModelCollectionUtils.nullSafeContainsAny(transportTypes, SntTransportTypeV1.MARINE)) {
            isValid = this.setupContextWithValidationError(context, "transportTypes", "{sntShippingInfoV1.transportTypes.MARINE.notNull}");
        }
        if (!CollectionUtils.isEmpty(transportTypes) && transportTypes.contains(SntTransportTypeV1.MULTIMODAL) && (sntTransportTypeSet = new HashSet(transportTypes)).size() < 2) {
            isValid = this.setupContextWithValidationError(context, "transportTypes", "{sntShippingInfoV1.transportTypes.MULTIMODAL.otherTypesExpected}");
        }
        return isValid;
    }
}

