/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.doc;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DocumentGtdHistory {
    private String gtdNumber;
    private String rowNumber;
    private String innerRowNumber;
    private List<VersionedValue<?, ?>> versionedValues = new ArrayList();

    private DocumentGtdHistory() {
    }

    public static DocumentGtdHistory build(String gtdNumber, String rowNumber, String innerRowNumber) {
        DocumentGtdHistory gtdHistory = new DocumentGtdHistory();
        gtdHistory.gtdNumber = gtdNumber;
        gtdHistory.rowNumber = rowNumber;
        gtdHistory.innerRowNumber = innerRowNumber;
        return gtdHistory;
    }

    public <K, T> DocumentGtdHistory addValue(String name, K version, T value) {
        Optional<VersionedValue> storedValue = this.versionedValues.stream().filter(versionedValue -> versionedValue.getName().equals(name)).findFirst();
        VersionedValue versionedValue2 = new VersionedValue(name);
        if (storedValue.isPresent()) {
            versionedValue2 = storedValue.get();
        } else {
            this.versionedValues.add(versionedValue2);
        }
        versionedValue2.addVersion(version, value);
        return this;
    }

    public String getGtdNumber() {
        return this.gtdNumber;
    }

    public String getRowNumber() {
        return this.rowNumber;
    }

    public String getInnerRowNumber() {
        return this.innerRowNumber;
    }

    public <K> List<VersionedValuePresentation<K>> getPresentation(Comparator<K> comparator) {
        return VersionedValueReader.build(comparator).getVersionPresentation(this, this.versionedValues.get(0).getKeys());
    }

    private static class VersionedValueReader<K> {
        private static final String NOT_CHANGED_MESSAGE = "\u0411\u0435\u0437 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439";
        private Comparator<K> comparator;

        private VersionedValueReader() {
        }

        public static <K> VersionedValueReader build(Comparator<K> comparator) {
            VersionedValueReader<K> reader = new VersionedValueReader<K>();
            reader.comparator = comparator;
            return reader;
        }

        public <T> Map<K, Object> process(Map<K, T> versionedValues) {
            HashMap processedValues = new HashMap();
            ArrayList<K> versionList = new ArrayList<K>(versionedValues.keySet());
            versionList.sort(this.comparator);
            for (Object version : versionList) {
                Object previousVersion = versionList.indexOf(version) == 0 ? null : versionList.get(versionList.indexOf(version) - 1);
                processedValues.put(version, VersionedValueReader.read(versionedValues.get(previousVersion), versionedValues.get(version), previousVersion != null));
            }
            return processedValues;
        }

        public List<VersionedValuePresentation<K>> getVersionPresentation(DocumentGtdHistory history, Set<K> versionSet) {
            ArrayList<K> versions = new ArrayList<K>(versionSet);
            versions.sort(this.comparator);
            Set fieldNames = history.versionedValues.stream().map(VersionedValue::getName).collect(Collectors.toSet());
            ArrayList<VersionedValuePresentation<K>> versionedValuePresentations = new ArrayList<VersionedValuePresentation<K>>();
            for (Object currentVersion : versions) {
                Object previousVersion;
                Object k = previousVersion = versions.indexOf(currentVersion) == 0 ? null : (Object)versions.get(versions.indexOf(currentVersion) - 1);
                if (previousVersion == null) continue;
                HashMap<String, Object> currentValuesMap = new HashMap<String, Object>();
                HashMap<String, Object> previousValuesMap = new HashMap<String, Object>();
                for (String fieldName : fieldNames) {
                    VersionedValue previousVersionValue = history.versionedValues.stream().filter(versionedValue -> ((VersionedValue)versionedValue).name.equals(fieldName)).findFirst().get();
                    VersionedValue currentVersionValue = history.versionedValues.stream().filter(versionedValue -> ((VersionedValue)versionedValue).name.equals(fieldName)).findFirst().get();
                    Object compareResult = VersionedValueReader.read(previousVersionValue.getValue(previousVersion), currentVersionValue.getValue(currentVersion), previousVersion != null);
                    currentValuesMap.put(fieldName, previousVersionValue.getValue(previousVersion));
                    previousValuesMap.put(fieldName, compareResult);
                }
                versionedValuePresentations.add(new VersionedValuePresentation<Object>(previousVersion, currentVersion, (Map<String, Object>)currentValuesMap, (Map<String, Object>)previousValuesMap, history.rowNumber));
            }
            return versionedValuePresentations;
        }

        public static <T> Object read(T previousValue, T currentValue, boolean hasPreviousVersion) {
            if (Objects.equals(previousValue, currentValue) && hasPreviousVersion) {
                return NOT_CHANGED_MESSAGE;
            }
            return currentValue;
        }
    }

    public static class VersionedValuePresentation<K> {
        @JsonIgnore
        private final K currentVersion;
        @JsonIgnore
        private final K previousVersion;
        private final String rowNum;
        @JsonIgnore
        private Map<String, Object> currentValues;
        @JsonIgnore
        private Map<String, Object> previousValues;

        public VersionedValuePresentation(K currentVersion, K previousVersion, Map<String, Object> currentValues, Map<String, Object> previousValues, String rowNum) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.currentValues = currentValues;
            this.previousValues = previousValues;
            this.rowNum = rowNum;
        }

        @JsonGetter
        public Map<K, Map<String, Object>> getCurrentValues() {
            HashMap<K, Map<String, Object>> resultMap = new HashMap<K, Map<String, Object>>();
            resultMap.put(this.currentVersion, this.currentValues);
            resultMap.put(this.previousVersion, this.previousValues);
            return resultMap;
        }
    }

    public static class VersionedValue<K, T> {
        private final String name;
        private final Map<K, T> values = new HashMap<K, T>();
        @JsonIgnore
        private final Comparator<K> versionComparator;

        public VersionedValue(String name) {
            this.name = name;
            this.versionComparator = (v1, v2) -> v1.toString().compareTo(v2.toString());
        }

        public VersionedValue(String name, Comparator<K> versionComparator) {
            this.name = name;
            this.versionComparator = versionComparator;
        }

        public void addVersion(K version, T value) {
            this.values.put(version, value);
        }

        @JsonGetter
        public Map<K, Object> getValues() {
            return VersionedValueReader.build(this.versionComparator).process(this.values);
        }

        @JsonGetter
        public String getName() {
            return this.name;
        }

        public <K> T getValue(K version) {
            return this.values.get(version);
        }

        public Set<K> getKeys() {
            return this.values.keySet();
        }
    }
}

