/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.settings;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateTimeAdapter;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.vstore.model.settings.UserVstoreDocumentSettings;
import ru.uss.vstore.model.settings.UserVstoreDocumentType;
import ru.uss.vstore.model.settings.UserVstoreSettingsType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="UserVstoreChangeRecord")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043e \u0441\u043c\u0435\u043d\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0418\u0421 \"\u042d\u0421\u0424\"")
public class UserVstoreChangeRecord {
    @NotNull(message="{user.vstore.settings.tin.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private @NotNull(message="{user.vstore.settings.tin.notNull}") String tin;
    @NotNull(message="{user.vstore.settings.changeDate.notNull}")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043c\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a")
    private @NotNull(message="{user.vstore.settings.changeDate.notNull}") Date changeDate;
    @NotNull(message="{user.vstore.settings.participantType.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0418\u0421 \u042d\u0421\u0424")
    private @NotNull(message="{user.vstore.settings.participantType.notNull}") DocumentParticipantType participantType;
    @Valid
    @Size(min=2, max=3, message="user.vstore.settings.documentSettingsList.size")
    @XmlElementWrapper(required=true)
    @XmlElement(name="documentSettings", required=true)
    @Documentation(value="\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 \u0412\u0421")
    private @Valid @Size(min=2, max=3, message="user.vstore.settings.documentSettingsList.size") List<UserVstoreDocumentSettings> documentSettingsList;

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public DocumentParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(DocumentParticipantType participantType) {
        this.participantType = participantType;
    }

    public List<UserVstoreDocumentSettings> getDocumentSettingsList() {
        return this.documentSettingsList;
    }

    public void setDocumentSettingsList(List<UserVstoreDocumentSettings> documentSettingsList) {
        this.documentSettingsList = documentSettingsList;
    }

    public UserVstoreSettingsType getDtZvtSettings() {
        return this.getSettings(UserVstoreDocumentType.DOCUMENT_GTD_ZVT);
    }

    public UserVstoreSettingsType getSntSettings() {
        return this.getSettings(UserVstoreDocumentType.SNT);
    }

    public UserVstoreSettingsType getSntTransferSettings() {
        return this.getSettings(UserVstoreDocumentType.SNT_TRANSFER);
    }

    public UserVstoreSettingsType getSettings(UserVstoreDocumentType documentType) {
        return this.documentSettingsList == null ? null : (UserVstoreSettingsType)this.documentSettingsList.stream().filter(settings -> documentType.equals((Object)settings.getDocumentType())).filter(Objects::nonNull).map(UserVstoreDocumentSettings::getSettingsType).findAny().orElse(null);
    }
}

