/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.store;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.vstore.model.store.EStoreType;
import ru.uss.vstore.model.store.TaxpayerStoreStatus;
import ru.uss.vstore.validation.store.TaxpayerStoreLessee;
import ru.uss.vstore.validation.store.TaxpayerStoreMobile;

@TaxpayerStoreMobile
@TaxpayerStoreLessee
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TaxpayerStore")
@Documentation(value="\u0421\u043a\u043b\u0430\u0434 \u041d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430")
public class TaxpayerStore
implements Serializable {
    private static final String SYSTEM_STORE_NAME = "\u0421\u043a\u043b\u0430\u0434 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u041d\u041f";
    private static final String ARCHIVE_STORE_NAME = "\u0421\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0435 \u0442\u043e\u0432\u0430\u0440\u044b";
    private static final String SYSTEM_POSTING_GOODS_STORE_NAME = "\u041d\u0435\u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0442\u043e\u0432\u0430\u0440\u044b \u041d\u041f";
    private static final String SYSTEM_STORE_RESPONSIBLE_IIN = "SYSTEM";
    @XmlElement
    @Documentation(value="ID")
    private Long id;
    @Tin
    @NotNull(message="{taxpayerStore.tin.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0411\u0418\u041d")
    private @NotNull(message="{taxpayerStore.tin.notNull}") String tin;
    @Documentation(value="\u0424\u043e\u0440\u043c\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    @XmlElement
    private DocumentParticipantType participantType;
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    @XmlElement
    private Long projectCode;
    @RequiredString(maxLen=100, fieldPath="taxpayerStore.storeName")
    @NotNull(message="{taxpayerStore.storeName.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u043b\u0430\u0434\u0430")
    private @NotNull(message="{taxpayerStore.storeName.notNull}") String storeName;
    @NotNull(message="{taxpayerStore.storeTypeCode.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u0441\u043a\u043b\u0430\u0434\u0430")
    private @NotNull(message="{taxpayerStore.storeTypeCode.notNull}") EStoreType storeTypeCode;
    @NotNull(message="{taxpayerStore.isDefault.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")
    private @NotNull(message="{taxpayerStore.isDefault.notNull}") Boolean isDefault;
    @XmlElement(required=false)
    @RequiredString(required=true, minLen=1, maxLen=450, fieldPath="taxpayerStore.address")
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u0441\u043a\u043b\u0430\u0434\u0430")
    private String address;
    @NotNull(message="{taxpayerStore.responsiblePersonIin.notNull}")
    @Tin(message="{taxpayerStore.responsiblePersonIin.incorrect}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430")
    private @NotNull(message="{taxpayerStore.responsiblePersonIin.notNull}") String responsiblePersonIin;
    @XmlElement
    @Documentation(value="ID \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0441\u043a\u043b\u0430\u0434\u0430")
    private Long parentId;
    @NotNull(message="{taxpayerStore.isInherited.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043d\u0430\u0441\u043b\u0435\u0434\u0443\u0435\u043c\u043e\u0441\u0442\u0438")
    private @NotNull(message="{taxpayerStore.isInherited.notNull}") Boolean isInherited;
    @NotNull(message="{taxpayerStore.isPostingGoods.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043e\u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430")
    private @NotNull(message="{taxpayerStore.isPostingGoods.notNull}") Boolean isPostingGoods;
    @NotNull(message="{taxpayerStore.isJointStore.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0441\u043a\u043b\u0430\u0434\u0430 \u0434\u043b\u044f \u0423\u0421\u0414")
    private @NotNull(message="{taxpayerStore.isJointStore.notNull}") Boolean isJointStore;
    @XmlElement
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0411\u0418\u041d-\u043e\u0432 \u0423\u0421\u0414")
    private List<String> permittedTinList;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u043a\u043b\u0430\u0434\u0430")
    private Boolean isCooperativeStore;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0443\u0431\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u0441\u043a\u043b\u0430\u0434\u0430")
    private Boolean isPublicStore;
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u0430\u0432\u0430\u043b\u044c\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0441\u044b\u0440\u044c\u044f")
    private Boolean isRawMaterials;
    @Tin(message="{taxpayerStore.lesseeTin.incorrect}")
    @XmlElement(required=false)
    @Documentation(value="\u0411\u0418\u041d/\u0418\u0418\u041d \u041b\u0438\u0437\u0438\u043d\u0433\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f")
    private String lesseeTin;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043b\u0438\u0437\u0438\u043d\u0433\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f")
    private String lesseeContractNumber;
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043b\u0438\u0437\u0438\u043d\u0433\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f")
    private Date lesseeContractDate;
    @XmlElement
    @Documentation(value="\u0421\u043a\u0430\u043d \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e\u0449\u0438\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e \u0441\u043a\u043b\u0430\u0434\u0435")
    private Long documentId;
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u041e\u0412\u0414 \u043f\u043e \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u043c \u0432\u0438\u0434\u0430\u043c \u043d\u0435\u0444\u0442\u0435\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432")
    private Long oilOvdId;
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u041e\u0412\u0414 \u043f\u043e \u0442\u0430\u0431\u0430\u0447\u043d\u044b\u043c \u0438\u0437\u0434\u0435\u043b\u0438\u044f\u043c")
    private Long tobaccoOvdId;
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 \u043d\u0430 \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0443\u044e \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044e")
    private Long alcoholLicenseId;
    @NotNull
    @XmlElement
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0421\u043a\u043b\u0430\u0434\u0430 \u041d\u041f \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u042d\u0421\u0424")
    private TaxpayerStoreStatus status;
    @XmlElement(required=false)
    @Documentation(value="\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u042d\u0421\u0424 (\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0441\u043a\u043b\u0430\u0434\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c \"\u0410\u0440\u0445\u0438\u0432\")")
    private Boolean isOpenedForInvoice = true;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public DocumentParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(DocumentParticipantType participantType) {
        this.participantType = participantType;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public EStoreType getStoreTypeCode() {
        return this.storeTypeCode;
    }

    public void setStoreTypeCode(EStoreType storeTypeCode) {
        this.storeTypeCode = storeTypeCode;
    }

    public Boolean getDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean aDefault) {
        this.isDefault = aDefault;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getResponsiblePersonIin() {
        return this.responsiblePersonIin;
    }

    public void setResponsiblePersonIin(String responsiblePersonIin) {
        this.responsiblePersonIin = responsiblePersonIin;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getInherited() {
        return this.isInherited;
    }

    public void setInherited(Boolean inherited) {
        this.isInherited = inherited;
    }

    public Boolean getPostingGoods() {
        return this.isPostingGoods;
    }

    public void setPostingGoods(Boolean postingGoods) {
        this.isPostingGoods = postingGoods;
    }

    public Boolean getJointStore() {
        return this.isJointStore;
    }

    public void setJointStore(Boolean jointStore) {
        this.isJointStore = jointStore;
    }

    public List<String> getPermittedTinList() {
        return this.permittedTinList;
    }

    public void setPermittedTinList(List<String> permittedTinList) {
        this.permittedTinList = permittedTinList;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public Long getOilOvdId() {
        return this.oilOvdId;
    }

    public void setOilOvdId(Long oilOvdId) {
        this.oilOvdId = oilOvdId;
    }

    public Long getTobaccoOvdId() {
        return this.tobaccoOvdId;
    }

    public void setTobaccoOvdId(Long tobaccoOvdId) {
        this.tobaccoOvdId = tobaccoOvdId;
    }

    public Long getAlcoholLicenseId() {
        return this.alcoholLicenseId;
    }

    public void setAlcoholLicenseId(Long alcoholLicenseId) {
        this.alcoholLicenseId = alcoholLicenseId;
    }

    public TaxpayerStoreStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaxpayerStoreStatus status) {
        this.status = status;
    }

    public Boolean getCooperativeStore() {
        return this.isCooperativeStore;
    }

    public void setCooperativeStore(Boolean cooperativeStore) {
        this.isCooperativeStore = cooperativeStore;
    }

    public Boolean getPublicStore() {
        return this.isPublicStore;
    }

    public void setPublicStore(Boolean publicStore) {
        this.isPublicStore = publicStore;
    }

    public Boolean getRawMaterials() {
        return this.isRawMaterials;
    }

    public void setRawMaterials(Boolean rawMaterials) {
        this.isRawMaterials = rawMaterials;
    }

    public String getLesseeTin() {
        return this.lesseeTin;
    }

    public void setLesseeTin(String lesseeTin) {
        this.lesseeTin = lesseeTin;
    }

    public String getLesseeContractNumber() {
        return this.lesseeContractNumber;
    }

    public void setLesseeContractNumber(String lesseeContractNumber) {
        this.lesseeContractNumber = lesseeContractNumber;
    }

    public Date getLesseeContractDate() {
        return this.lesseeContractDate;
    }

    public void setLesseeContractDate(Date lesseeContractDate) {
        this.lesseeContractDate = lesseeContractDate;
    }

    public boolean isSystemStore() {
        return SYSTEM_STORE_RESPONSIBLE_IIN.equals(this.responsiblePersonIin);
    }

    public boolean isPostingGoods() {
        return BooleanUtils.isTrue((Boolean)this.isPostingGoods);
    }

    public Boolean getOpenedForInvoice() {
        return this.isOpenedForInvoice;
    }

    public void setOpenedForInvoice(Boolean openedForInvoice) {
        this.isOpenedForInvoice = openedForInvoice;
    }

    public static TaxpayerStore createDefault(String tin, Boolean isDefault, Boolean isPostingGoods, Long projectCode, DocumentParticipantType participantType) {
        TaxpayerStore taxpayerStore = new TaxpayerStore();
        String storeName = String.format("%s %s%s", SYSTEM_STORE_NAME, DocumentParticipantType.BUSINESS.equals((Object)participantType) ? "" : "(" + participantType.getPrefix() + ")", tin);
        if (Boolean.TRUE.equals(isPostingGoods)) {
            storeName = String.format("%s %s%s", SYSTEM_POSTING_GOODS_STORE_NAME, DocumentParticipantType.BUSINESS.equals((Object)participantType) ? "" : "(" + participantType.getPrefix() + ")", tin);
        }
        taxpayerStore.setStoreName(storeName);
        taxpayerStore.setTin(tin);
        taxpayerStore.setProjectCode(projectCode);
        taxpayerStore.setStoreTypeCode(EStoreType.STORE_HOUSE);
        taxpayerStore.setDefault(isDefault);
        taxpayerStore.setInherited(false);
        taxpayerStore.setJointStore(false);
        taxpayerStore.setPostingGoods(isPostingGoods);
        taxpayerStore.setResponsiblePersonIin(SYSTEM_STORE_RESPONSIBLE_IIN);
        taxpayerStore.setStatus(TaxpayerStoreStatus.VALID);
        taxpayerStore.setParticipantType(participantType);
        taxpayerStore.setCooperativeStore(false);
        taxpayerStore.setRawMaterials(false);
        taxpayerStore.setPublicStore(false);
        return taxpayerStore;
    }

    public static TaxpayerStore createArchive(String tin, Long projectCode, DocumentParticipantType participantType) {
        TaxpayerStore taxpayerStore = new TaxpayerStore();
        String storeName = String.format("%s %s", ARCHIVE_STORE_NAME, tin);
        taxpayerStore.setStoreName(storeName);
        taxpayerStore.setTin(tin);
        taxpayerStore.setProjectCode(projectCode);
        taxpayerStore.setStoreTypeCode(EStoreType.ARCHIVE_STORE);
        taxpayerStore.setDefault(false);
        taxpayerStore.setInherited(false);
        taxpayerStore.setJointStore(false);
        taxpayerStore.setPostingGoods(false);
        taxpayerStore.setResponsiblePersonIin(SYSTEM_STORE_RESPONSIBLE_IIN);
        taxpayerStore.setStatus(TaxpayerStoreStatus.VALID);
        taxpayerStore.setParticipantType(participantType);
        taxpayerStore.setCooperativeStore(false);
        taxpayerStore.setRawMaterials(false);
        taxpayerStore.setPublicStore(false);
        return taxpayerStore;
    }

    public String toString() {
        return "TaxpayerStore{id=" + this.id + '}';
    }

    public boolean isArchiveStore() {
        return EStoreType.ARCHIVE_STORE.equals((Object)this.storeTypeCode);
    }
}

